/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.Activator;
import org.eclipse.chemclipse.model.support.SegmentWidth;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String P_NOISE_CALCULATOR_ID = "noiseCalculatorId";
    public static final String DEF_NOISE_CALCULATOR_ID = "org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.noise.dyson";
    public static final String P_SEGMENT_WIDTH = "segmentWidth";
    public static final String DEF_SEGMENT_WIDTH = SegmentWidth.WIDTH_13.toString();
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public static boolean isAvailable() {
        return Activator.getContext() != null;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        BundleContext context = Activator.getContext();
        if (context != null) {
            return context.getBundle().getSymbolicName();
        }
        return this.getClass().getName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_NOISE_CALCULATOR_ID, DEF_NOISE_CALCULATOR_ID);
        defaultValues.put(DEF_SEGMENT_WIDTH, DEF_SEGMENT_WIDTH);
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static String getSelectedNoiseCalculatorId() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.get(P_NOISE_CALCULATOR_ID, DEF_NOISE_CALCULATOR_ID);
    }

    public static int getSelectedSegmentWidth() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        SegmentWidth segmentWidth = SegmentWidth.valueOf((String)preferences.get(P_SEGMENT_WIDTH, DEF_SEGMENT_WIDTH));
        return segmentWidth.getWidth();
    }

    public static SegmentWidth getDefaultSegmentWidth() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        SegmentWidth segmentWidth = SegmentWidth.valueOf((String)preferences.get(P_SEGMENT_WIDTH, DEF_SEGMENT_WIDTH));
        return segmentWidth;
    }
}

