/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddPeaksPageESTD
extends WizardPage {
    private static final Logger logger = Logger.getLogger(AddPeaksPageESTD.class);
    private double concentration = 0.0;
    private String concentrationUnit = "";
    private String chemicalClass = "";
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public AddPeaksPageESTD(String pageName) {
        super(pageName);
        this.setTitle("Peaks to Quantitation Table");
        this.setDescription("Set the concentration details.");
        this.setErrorMessage("Please add a concentration.");
    }

    protected double getConcentration() {
        return this.concentration;
    }

    protected String getConcentrationUnit() {
        return this.concentrationUnit;
    }

    protected String getChemicalClass() {
        return this.chemicalClass;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createLabel(composite, "Concentration*:");
        this.createTextConcentration(composite);
        this.createLabel(composite, "Concentration Unit*:");
        this.createTextConcentrationUnit(composite);
        this.createLabel(composite, "Chemical Class:");
        this.createTextChemicalClass(composite);
        this.setControl((Control)composite);
    }

    private void createTextConcentration(Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String value = text.getText();
                if (value == null || value.equals("")) {
                    AddPeaksPageESTD.this.setErrorMessage("Please set a concentration, e.g. 2.5.");
                } else {
                    try {
                        AddPeaksPageESTD.this.concentration = AddPeaksPageESTD.this.decimalFormat.parse(value).doubleValue();
                        AddPeaksPageESTD.this.setErrorMessage(null);
                    }
                    catch (ParseException e1) {
                        logger.warn((Object)e1);
                        AddPeaksPageESTD.this.setErrorMessage("Please type in a valid concentration.");
                    }
                }
            }
        });
    }

    private void createTextConcentrationUnit(Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String value = text.getText();
                if (value == null || value.equals("")) {
                    AddPeaksPageESTD.this.setErrorMessage("Please set a concentration unit, e.g. mg/kg.");
                } else {
                    AddPeaksPageESTD.this.concentrationUnit = value;
                    AddPeaksPageESTD.this.setErrorMessage(null);
                }
            }
        });
    }

    private void createTextChemicalClass(Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String value = text.getText();
                if (value != null && !value.equals("")) {
                    AddPeaksPageESTD.this.chemicalClass = value;
                }
            }
        });
    }

    private void createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
    }
}

