/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.internal.wizards;

import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakOutputEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.PeakOutputEntry;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.msd.converter.peak.IPeakConverterSupport;
import org.eclipse.chemclipse.msd.converter.peak.PeakConverterMSD;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PeakOutputFilesWizardPage
extends WizardPage {
    private Combo peakConverterComboBox;
    private Text peakOutputFolderTextBox;
    private IPeakConverterSupport converterSupport;

    protected PeakOutputFilesWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Peak Output Formats");
        this.setDescription("This wizard lets you select several output peak formats.");
    }

    public IPeakOutputEntry getPeakOutputEntry() throws NoConverterAvailableException {
        String converterId = "";
        String outputFolder = "";
        int index = this.peakConverterComboBox.getSelectionIndex();
        if (index < 0) {
            throw new NoConverterAvailableException("No converter has been selected.");
        }
        String description = this.peakConverterComboBox.getItem(index);
        converterId = this.converterSupport.getConverterId(description, true);
        outputFolder = this.peakOutputFolderTextBox.getText();
        if (outputFolder == null || outputFolder.equals("")) {
            throw new NoConverterAvailableException("The output folder must not be null.");
        }
        return new PeakOutputEntry(outputFolder, converterId);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.converterSupport = PeakConverterMSD.getPeakConverterSupport();
        try {
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.heightHint = 30;
            Label label = new Label(composite, 0);
            label.setText("Select the output file converter:");
            label.setLayoutData((Object)gridData);
            String[] filterNames = this.converterSupport.getExportableFilterNames();
            this.peakConverterComboBox = new Combo(composite, 0);
            this.peakConverterComboBox.setItems(filterNames);
            this.peakConverterComboBox.setLayoutData((Object)gridData);
            label = new Label(composite, 0);
            label.setText("Select the output folder:");
            gridData.verticalIndent = 20;
            label.setLayoutData((Object)gridData);
            this.peakOutputFolderTextBox = new Text(composite, 2048);
            this.peakOutputFolderTextBox.setLayoutData((Object)new GridData(768));
            Button button = new Button(composite, 0);
            button.setText("Select folder");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Shell shell = Display.getCurrent().getActiveShell();
                    DirectoryDialog dialog = new DirectoryDialog(shell);
                    dialog.setText("Select chromatogram format output folder:");
                    String reportFolder = dialog.open();
                    if (reportFolder != null) {
                        PeakOutputFilesWizardPage.this.peakOutputFolderTextBox.setText(reportFolder);
                    }
                }
            });
        }
        catch (NoConverterAvailableException e) {
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            gridData.heightHint = 30;
            Label label = new Label(composite, 0);
            label.setText("Sorry, there are no output converters available.");
            label.setLayoutData((Object)gridData);
        }
        this.setControl((Control)composite);
    }
}

