/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.comparison.exceptions.ComparisonException;
import org.eclipse.chemclipse.chromatogram.msd.comparison.exceptions.NoMassSpectrumComparatorAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.comparison.internal.massspectrum.ComparatorCache;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.AbstractMassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparatorSupport;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparisonSupplier;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.MassSpectrumComparatorSupport;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.MassSpectrumComparisonSupplier;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.purity.IMassSpectrumPurityResult;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.purity.MassSpectrumPurityResult;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.MatchConstraints;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class MassSpectrumComparator {
    private static final Logger logger = Logger.getLogger(MassSpectrumComparator.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.msd.comparison.massSpectrumComparisonSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String COMPARATOR_NAME = "comparatorName";
    private static final String MASS_SPECTRUM_COMPARATOR = "massSpectrumComparator";
    private static final String SUPPORTS_NOMINAL_MS = "nominalMS";
    private static final String SUPPORTS_TANDEM_MS = "tandemMS";
    private static final String SUPPORTS_HIGH_RESOLUTION_MS = "highResolutionMS";
    private static ComparatorCache comparatorCache = new ComparatorCache();
    private static IProcessingInfo<IComparisonResult> processingInfoComparisonSkip = new ProcessingInfo();
    private static final float NO_MATCH = 0.0f;

    static {
        processingInfoComparisonSkip.setProcessingResult((Object)new ComparisonResult(0.0f, 0.0f, 0.0f, 0.0f));
    }

    private MassSpectrumComparator() {
    }

    public static IProcessingInfo<IComparisonResult> compare(IScanMSD unknown, IScanMSD reference, String comparatorId, boolean usePreOptimization, double thresholdPreOptimization) {
        if (comparatorId == null || comparatorId.isEmpty()) {
            comparatorId = "org.eclipse.chemclipse.chromatogram.msd.comparison.supplier.distance.cosine";
        }
        return MassSpectrumComparator.compare(unknown, reference, MassSpectrumComparator.getMassSpectrumComparator(comparatorId), usePreOptimization, thresholdPreOptimization);
    }

    public static IProcessingInfo<IComparisonResult> compare(IScanMSD unknown, IScanMSD reference, IMassSpectrumComparator massSpectrumComparator, boolean usePreOptimization, double thresholdPreOptimization) {
        IProcessingInfo<IComparisonResult> processingInfo;
        boolean compare = true;
        if (usePreOptimization) {
            compare = comparatorCache.useReferenceForComparison(unknown, reference, thresholdPreOptimization);
        }
        MatchConstraints matchConstraints = new MatchConstraints();
        if (compare) {
            if (massSpectrumComparator != null) {
                processingInfo = massSpectrumComparator.compare(unknown, reference, matchConstraints);
            } else {
                processingInfo = new IProcessingInfo<IComparisonResult>();
                processingInfo.addErrorMessage("MassSpectrum Comparator", "MassSpectrum comparator can't be null!");
            }
        } else {
            processingInfo = processingInfoComparisonSkip;
        }
        return processingInfo;
    }

    public static IProcessingInfo<IMassSpectrumPurityResult> getPurityResult(IScanMSD extractedMassSpectrum, IScanMSD genuineMassSpectrum) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        try {
            MassSpectrumPurityResult massSpectrumPurityResult = new MassSpectrumPurityResult(extractedMassSpectrum, genuineMassSpectrum);
            processingInfo.setProcessingResult((Object)massSpectrumPurityResult);
        }
        catch (ComparisonException e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            processingInfo.addErrorMessage("MassSpectrum Purity", "The mass spectrum purity couldn't be calculated.");
        }
        return processingInfo;
    }

    public static String[][] getAvailableComparatorIds() {
        IMassSpectrumComparatorSupport massSpectrumComparatorSupport = MassSpectrumComparator.getMassSpectrumComparatorSupport();
        String[][] comparatorArray = null;
        try {
            List<String> comparatorIds = massSpectrumComparatorSupport.getAvailableComparatorIds();
            int size = comparatorIds.size();
            comparatorArray = new String[size][2];
            int i = 0;
            while (i < size) {
                String name;
                String converterId;
                try {
                    converterId = comparatorIds.get(i);
                    name = massSpectrumComparatorSupport.getMassSpectrumComparisonSupplier(converterId).getComparatorName();
                }
                catch (Exception e) {
                    logger.warn((Object)e);
                    converterId = "";
                    name = "n.a.";
                }
                comparatorArray[i][0] = name;
                comparatorArray[i][1] = converterId;
                ++i;
            }
        }
        catch (NoMassSpectrumComparatorAvailableException e1) {
            logger.warn((Object)e1);
        }
        if (comparatorArray == null) {
            comparatorArray = new String[0][0];
        }
        return comparatorArray;
    }

    public static IMassSpectrumComparatorSupport getMassSpectrumComparatorSupport() {
        IConfigurationElement[] extensions;
        MassSpectrumComparatorSupport massSpectrumComparisonSupport = new MassSpectrumComparatorSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            IMassSpectrumComparisonSupplier massSpectrumComparisonSupplier = MassSpectrumComparator.getMassSpectrumComparisonSupplier(element);
            massSpectrumComparisonSupport.add(massSpectrumComparisonSupplier);
            ++n2;
        }
        return massSpectrumComparisonSupport;
    }

    public static IMassSpectrumComparator getMassSpectrumComparator(String comparatorId) {
        IConfigurationElement element = MassSpectrumComparator.getConfigurationElement(comparatorId);
        IMassSpectrumComparator instance = null;
        if (element != null) {
            try {
                instance = (IMassSpectrumComparator)element.createExecutableExtension(MASS_SPECTRUM_COMPARATOR);
                IMassSpectrumComparisonSupplier massSpectrumComparisonSupplier = MassSpectrumComparator.getMassSpectrumComparisonSupplier(element);
                ((AbstractMassSpectrumComparator)instance).setMassSpectrumComparisonSupplier(massSpectrumComparisonSupplier);
            }
            catch (CoreException e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return instance;
    }

    private static IMassSpectrumComparisonSupplier getMassSpectrumComparisonSupplier(IConfigurationElement element) {
        MassSpectrumComparisonSupplier massSpectrumComparisonSupplier = new MassSpectrumComparisonSupplier();
        massSpectrumComparisonSupplier.setId(element.getAttribute(ID));
        massSpectrumComparisonSupplier.setDescription(element.getAttribute(DESCRIPTION));
        massSpectrumComparisonSupplier.setComparatorName(element.getAttribute(COMPARATOR_NAME));
        massSpectrumComparisonSupplier.setSupportsNominalMS(Boolean.valueOf(element.getAttribute(SUPPORTS_NOMINAL_MS)));
        massSpectrumComparisonSupplier.setSupportsTandemMS(Boolean.valueOf(element.getAttribute(SUPPORTS_TANDEM_MS)));
        massSpectrumComparisonSupplier.setSupportsHighResolutionMS(Boolean.valueOf(element.getAttribute(SUPPORTS_HIGH_RESOLUTION_MS)));
        return massSpectrumComparisonSupplier;
    }

    private static IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

