/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.csd.peak.detector.core;

import org.eclipse.chemclipse.chromatogram.csd.peak.detector.core.IPeakDetectorCSD;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.core.IPeakDetectorCSDSupport;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.core.PeakDetectorCSDSupplier;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.core.PeakDetectorCSDSupport;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.settings.IPeakDetectorSettingsCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class PeakDetectorCSD {
    private static final Logger logger = Logger.getLogger(PeakDetectorCSD.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.csd.peak.detector.peakDetectorSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String PEAK_DETECTOR_NAME = "peakDetectorName";
    private static final String PEAK_DETECTOR = "peakDetector";
    private static final String PEAK_DETECTOR_SETTINGS = "peakDetectorSettings";
    private static final String NO_PEAK_DETECTOR_AVAILABLE = "There is no peak detector available.";

    private PeakDetectorCSD() {
    }

    public static IProcessingInfo detect(IChromatogramSelectionCSD chromatogramSelection, IPeakDetectorSettingsCSD peakDetectorSettings, String peakDetectorId, IProgressMonitor monitor) {
        IPeakDetectorCSD peakDetector = PeakDetectorCSD.getPeakDetector(peakDetectorId);
        IProcessingInfo processingInfo = peakDetector != null ? peakDetector.detect(chromatogramSelection, peakDetectorSettings, monitor) : PeakDetectorCSD.getNoPeakDetectorAvailableProcessingInfo();
        return processingInfo;
    }

    public static IProcessingInfo detect(IChromatogramSelectionCSD chromatogramSelection, String peakDetectorId, IProgressMonitor monitor) {
        IPeakDetectorCSD peakDetector = PeakDetectorCSD.getPeakDetector(peakDetectorId);
        IProcessingInfo processingInfo = peakDetector != null ? peakDetector.detect(chromatogramSelection, monitor) : PeakDetectorCSD.getNoPeakDetectorAvailableProcessingInfo();
        return processingInfo;
    }

    public static IPeakDetectorCSDSupport getPeakDetectorSupport() {
        IConfigurationElement[] extensions;
        PeakDetectorCSDSupport peakDetectorSupport = new PeakDetectorCSDSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute(ID);
            String description = element.getAttribute(DESCRIPTION);
            String peakDetectorName = element.getAttribute(PEAK_DETECTOR_NAME);
            PeakDetectorCSDSupplier supplier = new PeakDetectorCSDSupplier(id, description, peakDetectorName);
            if (element.getAttribute(PEAK_DETECTOR_SETTINGS) != null) {
                try {
                    IPeakDetectorSettingsCSD instance = (IPeakDetectorSettingsCSD)element.createExecutableExtension(PEAK_DETECTOR_SETTINGS);
                    supplier.setSettingsClass(instance.getClass());
                }
                catch (CoreException e) {
                    logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    supplier.setSettingsClass(null);
                }
            }
            peakDetectorSupport.add(supplier);
            ++n2;
        }
        return peakDetectorSupport;
    }

    private static IPeakDetectorCSD getPeakDetector(String peakDetectorId) {
        IConfigurationElement element = PeakDetectorCSD.getConfigurationElement(peakDetectorId);
        IPeakDetectorCSD instance = null;
        if (element != null) {
            try {
                instance = (IPeakDetectorCSD)element.createExecutableExtension(PEAK_DETECTOR);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String peakDetectorId) {
        IConfigurationElement[] elements;
        if ("".equals(peakDetectorId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(peakDetectorId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static IProcessingInfo getNoPeakDetectorAvailableProcessingInfo() {
        ProcessingInfo processingInfo = new ProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Peak Detector FID", NO_PEAK_DETECTOR_AVAILABLE);
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }
}

