/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.traces;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.util.NamedTraceListUtil;
import org.eclipse.chemclipse.ux.extension.xxd.ui.traces.NamedTrace;

public class NamedTraces {
    private static final Logger logger = Logger.getLogger(NamedTraces.class);
    private NamedTraceListUtil namedTraceListUtil = new NamedTraceListUtil();
    private final Map<String, NamedTrace> namedTraceMap = new HashMap<String, NamedTrace>();

    public NamedTraces() {
    }

    public NamedTraces(String namedTraces) {
        this.load(namedTraces);
    }

    public void addAll(Collection<NamedTrace> NamedTraces2) {
        for (NamedTrace namedTrace : NamedTraces2) {
            this.add(namedTrace);
        }
    }

    public void add(NamedTrace namedTrace) {
        this.namedTraceMap.put(namedTrace.getIdentifier(), namedTrace);
    }

    public void remove(String identifier) {
        this.namedTraceMap.remove(identifier);
    }

    public void remove(List<NamedTrace> namedTraces) {
        for (NamedTrace namedTrace : namedTraces) {
            this.remove(namedTrace);
        }
    }

    public void remove(NamedTrace namedTrace) {
        if (namedTrace != null) {
            this.namedTraceMap.remove(namedTrace.getIdentifier());
        }
    }

    public NamedTrace get(String identifier) {
        return this.namedTraceMap.get(identifier);
    }

    public Set<String> keySet() {
        return this.namedTraceMap.keySet();
    }

    public Collection<NamedTrace> values() {
        return this.namedTraceMap.values();
    }

    public void clear() {
        this.namedTraceMap.clear();
    }

    public String extractNamedTrace(NamedTrace namedTrace) {
        StringBuilder builder = new StringBuilder();
        this.extractNamedTrace(namedTrace, builder);
        return builder.toString();
    }

    public NamedTrace extractNamedTrace(String item) {
        NamedTrace namedTrace = null;
        if (!"".equals(item)) {
            String[] values = item.split("\\|");
            String identifier = values.length > 0 ? values[0].trim() : "";
            String traces = values.length > 1 ? values[1].trim() : "";
            namedTrace = new NamedTrace(identifier, traces);
        }
        return namedTrace;
    }

    public void load(String timeRanges) {
        this.loadSettings(timeRanges);
    }

    public void loadDefault(String timeRanges) {
        this.loadSettings(timeRanges);
    }

    public String save() {
        StringBuilder builder = new StringBuilder();
        Iterator<NamedTrace> iterator = this.values().iterator();
        while (iterator.hasNext()) {
            NamedTrace namedTrace = iterator.next();
            this.extractNamedTrace(namedTrace, builder);
            if (!iterator.hasNext()) continue;
            builder.append(";");
        }
        return builder.toString().trim();
    }

    public void importItems(File file) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    NamedTrace template = this.extractNamedTrace(line);
                    if (template == null) continue;
                    this.add(template);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e);
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
    }

    public boolean exportItems(File file) {
        Throwable throwable = null;
        Object var3_5 = null;
        PrintWriter printWriter = new PrintWriter(file);
        try {
            ArrayList<NamedTrace> namedTraces = new ArrayList<NamedTrace>(this.values());
            Collections.sort(namedTraces, (r1, r2) -> r1.getIdentifier().compareTo(r2.getIdentifier()));
            Iterator iterator = namedTraces.iterator();
            while (iterator.hasNext()) {
                StringBuilder builder = new StringBuilder();
                NamedTrace template = (NamedTrace)iterator.next();
                this.extractNamedTrace(template, builder);
                printWriter.println(builder.toString());
            }
            printWriter.flush();
            if (printWriter != null) {
                printWriter.close();
            }
            return true;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    if (printWriter != null) {
                        printWriter.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
                return false;
            }
        }
    }

    private void loadSettings(String timeRanges) {
        String[] items;
        if (!"".equals(timeRanges) && (items = this.namedTraceListUtil.parseString(timeRanges)).length > 0) {
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                NamedTrace namedTrace = this.extractNamedTrace(item);
                if (namedTrace != null) {
                    this.add(namedTrace);
                }
                ++n2;
            }
        }
    }

    private void extractNamedTrace(NamedTrace namedTrace, StringBuilder builder) {
        builder.append(namedTrace.getIdentifier());
        builder.append(" ");
        builder.append("|");
        builder.append(" ");
        builder.append(namedTrace.getTraces());
    }
}

