/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.csd.filter.core.chromatogram.ChromatogramFilterCSD;
import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.ChromatogramFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.ChromatogramFilterMSD;
import org.eclipse.chemclipse.chromatogram.wsd.filter.core.chromatogram.ChromatogramFilterWSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ExtendedChromatogramUI;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.menu.AbstractChartMenuEntry;
import org.eclipse.swtchart.extensions.menu.IChartMenuEntry;

public class FilterMenuEntry
extends AbstractChartMenuEntry
implements IChartMenuEntry {
    private ExtendedChromatogramUI extendedChromatogramUI;
    private String name;
    private String filterId;
    private String type;
    private IChromatogramSelection chromatogramSelection;

    public FilterMenuEntry(ExtendedChromatogramUI extendedChromatogramUI, String name, String filterId, String type, IChromatogramSelection chromatogramSelection) {
        this.extendedChromatogramUI = extendedChromatogramUI;
        this.name = name;
        this.filterId = filterId;
        this.type = type;
        this.chromatogramSelection = chromatogramSelection;
    }

    public String getCategory() {
        return "Filter";
    }

    public String getName() {
        return this.name;
    }

    public void execute(Shell shell, ScrollableChart scrollableChart) {
        if (this.chromatogramSelection != null) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IProcessingInfo processingInfo = null;
                    switch (FilterMenuEntry.this.type) {
                        case "TYPE_GENERIC": {
                            processingInfo = ChromatogramFilter.applyFilter((IChromatogramSelection)FilterMenuEntry.this.chromatogramSelection, (String)FilterMenuEntry.this.filterId, (IProgressMonitor)monitor);
                            break;
                        }
                        case "TYPE_MSD": {
                            if (!(FilterMenuEntry.this.chromatogramSelection instanceof IChromatogramSelectionMSD)) break;
                            IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)FilterMenuEntry.this.chromatogramSelection;
                            processingInfo = ChromatogramFilterMSD.applyFilter((IChromatogramSelectionMSD)chromatogramSelectionMSD, (String)FilterMenuEntry.this.filterId, (IProgressMonitor)monitor);
                            break;
                        }
                        case "TYPE_CSD": {
                            if (!(FilterMenuEntry.this.chromatogramSelection instanceof IChromatogramSelectionCSD)) break;
                            IChromatogramSelectionCSD chromatogramSelectionCSD = (IChromatogramSelectionCSD)FilterMenuEntry.this.chromatogramSelection;
                            processingInfo = ChromatogramFilterCSD.applyFilter((IChromatogramSelectionCSD)chromatogramSelectionCSD, (String)FilterMenuEntry.this.filterId, (IProgressMonitor)monitor);
                            break;
                        }
                        case "TYPE_WSD": {
                            if (!(FilterMenuEntry.this.chromatogramSelection instanceof IChromatogramSelectionWSD)) break;
                            IChromatogramSelectionWSD chromatogramSelectionWSD = (IChromatogramSelectionWSD)FilterMenuEntry.this.chromatogramSelection;
                            processingInfo = ChromatogramFilterWSD.applyFilter((IChromatogramSelectionWSD)chromatogramSelectionWSD, (String)FilterMenuEntry.this.filterId, (IProgressMonitor)monitor);
                        }
                    }
                    if (processingInfo != null && !processingInfo.getMessages().isEmpty()) {
                        ProcessingInfoViewSupport.updateProcessingInfo(processingInfo, (boolean)false);
                    }
                }
            };
            this.extendedChromatogramUI.processChromatogram(runnable);
        }
    }
}

