/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.chemclipse.converter.model.reports.ISequence;
import org.eclipse.chemclipse.converter.model.reports.ISequenceRecord;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IMeasurement;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.IChromatogramSelectionProcessSupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.processing.methods.ProcessEntryContainer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionConsumer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.swt.ui.components.IMethodListener;
import org.eclipse.chemclipse.swt.ui.components.ISearchListener;
import org.eclipse.chemclipse.swt.ui.components.SearchSupportUI;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.methods.MethodSupportUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageChromatogram;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageSequences;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.ChromatogramTypeSupportUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.SequenceListUI;
import org.eclipse.chemclipse.xxd.process.support.ProcessTypeSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExtendedSequenceListUI {
    private static final Logger logger = Logger.getLogger(ExtendedSequenceListUI.class);
    private static final String DESCRIPTION = "Sequence Editor";
    private Text dataPath;
    private Composite toolbarSearch;
    private Composite toolbarDataPath;
    private Composite toolbarMethod;
    private SearchSupportUI searchSupportUI;
    private MethodSupportUI methodSupportUI;
    private SequenceListUI sequenceListUI;
    private String initialDataPath = "";
    private ISequence<? extends ISequenceRecord> sequence;
    private final ChromatogramTypeSupportUI chromatogramTypeSupport = new ChromatogramTypeSupportUI();
    private final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private final ProcessSupplierContext processSupplierContext;

    @Deprecated
    public ExtendedSequenceListUI(Composite parent) {
        this(parent, (ProcessSupplierContext)new ProcessTypeSupport());
    }

    public ExtendedSequenceListUI(Composite parent, ProcessSupplierContext processSupplierContext) {
        this.processSupplierContext = processSupplierContext;
        this.initialize(parent);
    }

    public void update(ISequence<? extends ISequenceRecord> sequence) {
        this.sequence = sequence;
        if (sequence != null) {
            this.initialDataPath = sequence.getDataPath();
        }
        this.updateDataSequenceData();
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarSearch = this.createToolbarSearch(parent);
        this.toolbarDataPath = this.createToolbarDataPath(parent);
        this.toolbarMethod = this.createToolbarMethod(parent);
        this.createSequenceList(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarSearch, (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbarDataPath, (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbarMethod, (boolean)false);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(6, false));
        this.createButtonToggleToolbarSearch(composite);
        this.createButtonToggleToolbarDataPath(composite);
        this.createButtonToggleToolbarMethod(composite);
        this.createBatchOpenButton(composite);
        this.createResetButton(composite);
        this.createSettingsButton(composite);
    }

    private Composite createToolbarSearch(Composite parent) {
        this.searchSupportUI = new SearchSupportUI(parent, 0);
        this.searchSupportUI.setLayoutData((Object)new GridData(768));
        this.searchSupportUI.setSearchListener(new ISearchListener(){

            public void performSearch(String searchText, boolean caseSensitive) {
                ExtendedSequenceListUI.this.sequenceListUI.setSearchText(searchText, caseSensitive);
            }
        });
        return this.searchSupportUI;
    }

    private Composite createToolbarDataPath(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(4, false));
        this.createDataPathLabel(composite);
        this.createDataPathText(composite);
        this.createSetDataPathButton(composite);
        this.createSelectDataPathButton(composite);
        return composite;
    }

    private Composite createToolbarMethod(Composite parent) {
        this.methodSupportUI = new MethodSupportUI(parent, 0);
        this.methodSupportUI.setLayoutData(new GridData(768));
        this.methodSupportUI.setMethodListener(new IMethodListener(){

            public void execute(IProcessMethod processMethod, IProgressMonitor monitor) {
                TableItem[] tableItems;
                ProcessingInfo processingInfo = new ProcessingInfo();
                TableItem[] tableItemArray = tableItems = ExtendedSequenceListUI.this.sequenceListUI.getTable().getItems();
                int n = tableItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    Object object = tableItem.getData();
                    if (object instanceof ISequenceRecord) {
                        ISequenceRecord sequenceRecord = (ISequenceRecord)object;
                        String pathChromatogram = String.valueOf(ExtendedSequenceListUI.this.sequence.getDataPath()) + File.separator + sequenceRecord.getDataFile();
                        IProcessingInfo processingInfoChromatogram = ExtendedSequenceListUI.this.chromatogramTypeSupport.getChromatogramSelection(pathChromatogram, monitor);
                        if (!processingInfoChromatogram.hasErrorMessages()) {
                            IChromatogramSelection chromatogramSelection = (IChromatogramSelection)processingInfoChromatogram.getProcessingResult();
                            ExtendedSequenceListUI.this.addSequenceRecordInformation(sequenceRecord, (IMeasurement)chromatogramSelection.getChromatogram());
                            ProcessingInfo processorInfo = new ProcessingInfo();
                            ProcessEntryContainer.applyProcessEntries((ProcessEntryContainer)processMethod, (ProcessExecutionContext)new ProcessExecutionContext(monitor, (MessageConsumer)processorInfo, ExtendedSequenceListUI.this.processSupplierContext), (ProcessExecutionConsumer)IChromatogramSelectionProcessSupplier.createConsumer((IChromatogramSelection)chromatogramSelection));
                            if (processorInfo.hasErrorMessages()) {
                                processingInfo.addMessages((IProcessingInfo)processorInfo);
                            } else {
                                processingInfo.addInfoMessage(ExtendedSequenceListUI.DESCRIPTION, "Success processing file: " + pathChromatogram);
                            }
                        } else {
                            processingInfo.addErrorMessage(ExtendedSequenceListUI.DESCRIPTION, "Failed to process the file: " + pathChromatogram);
                        }
                    }
                    ++n2;
                }
                ProcessingInfoViewSupport.updateProcessingInfo((Display)ExtendedSequenceListUI.this.methodSupportUI.getDisplay(), (MessageProvider)processingInfo, (boolean)true);
            }
        });
        return this.methodSupportUI;
    }

    private void addSequenceRecordInformation(ISequenceRecord sequenceRecord, IMeasurement measurement) {
        if (sequenceRecord != null && measurement != null) {
            measurement.putHeaderData("Sequence Description", sequenceRecord.getDescription());
            measurement.putHeaderData("Sequence Method", sequenceRecord.getProcessMethod());
            measurement.putHeaderData("Sequence Sample Name", sequenceRecord.getSampleName());
            measurement.putHeaderData("Sequence Substance", sequenceRecord.getSubstance());
            measurement.putHeaderData("Sequence Multiplier", Double.toString(sequenceRecord.getMultiplier()));
            measurement.putHeaderData("Sequence Vial", Integer.toString(sequenceRecord.getVial()));
        }
    }

    private void createDataPathLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Data Path:");
    }

    private void createDataPathText(Composite parent) {
        this.dataPath = new Text(parent, 2056);
        this.dataPath.setText("");
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.dataPath.setLayoutData((Object)gridData);
    }

    private Button createSetDataPathButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Set the data path folder.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/file.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file;
                if (ExtendedSequenceListUI.this.sequence != null && (file = new File(ExtendedSequenceListUI.this.sequence.getCanonicalPath())).exists()) {
                    ExtendedSequenceListUI.this.sequence.setDataPath(file.getParent());
                    ExtendedSequenceListUI.this.updateDataSequenceData();
                }
            }
        });
        return button;
    }

    private Button createSelectDataPathButton(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Select the data path folder.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedSequenceListUI.this.sequence != null) {
                    DirectoryDialog directoryDialog = new DirectoryDialog(DisplayUtils.getShell((Widget)button));
                    directoryDialog.setText("Sequence Folder");
                    directoryDialog.setMessage("Select the sequence root folder.");
                    IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
                    directoryDialog.setFilterPath(preferenceStore.getString("sequenceExplorerPathDialogFolder"));
                    String directory = directoryDialog.open();
                    if (directory != null) {
                        preferenceStore.setValue("sequenceExplorerPathDialogFolder", directory);
                        ExtendedSequenceListUI.this.sequence.setDataPath(directory);
                        ExtendedSequenceListUI.this.updateDataSequenceData();
                    }
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarSearch(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle search toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedSequenceListUI.this.toolbarSearch);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarDataPath(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the data path toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedSequenceListUI.this.toolbarDataPath);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editActive.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarMethod(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the method toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/method.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedSequenceListUI.this.toolbarMethod);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/method.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/method.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private void createBatchOpenButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the selected chromatograms");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/import.png", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Table table = ExtendedSequenceListUI.this.sequenceListUI.getTable();
                int[] indices = table.getSelectionIndices();
                ArrayList<File> files = new ArrayList<File>();
                String chromatogramProcessMethod = ExtendedSequenceListUI.this.preferenceStore.getString("chromatogramLoadProcessMethod");
                "".equals(chromatogramProcessMethod);
                int[] nArray = indices;
                int n = indices.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    Object object = table.getItem(index).getData();
                    if (object instanceof ISequenceRecord) {
                        ISequenceRecord sequenceRecord = (ISequenceRecord)object;
                        files.add(new File(String.valueOf(ExtendedSequenceListUI.this.sequence.getDataPath()) + File.separator + sequenceRecord.getDataFile()));
                    }
                    ++n2;
                }
                try {
                    ExtendedSequenceListUI.this.chromatogramTypeSupport.openFiles(files);
                }
                catch (Exception e1) {
                    ExtendedSequenceListUI.this.showDataPathWarningMessage(e.display.getActiveShell());
                    logger.warn((Object)e1);
                }
            }
        });
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the sequence");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedSequenceListUI.this.reset();
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePageSequences()));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)new PreferencePageChromatogram(Activator.getDefault().getPreferenceStore())));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedSequenceListUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
    }

    private void applySettings() {
        this.sequenceListUI.setComparator();
        this.searchSupportUI.reset();
        this.updateDataSequenceData();
    }

    private void reset() {
        this.searchSupportUI.reset();
        if (this.sequence != null) {
            this.sequence.setDataPath(this.initialDataPath);
        }
        this.updateDataSequenceData();
    }

    private void createSequenceList(Composite parent) {
        this.sequenceListUI = new SequenceListUI(parent, 268503810);
        Table table = this.sequenceListUI.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object object = ExtendedSequenceListUI.this.sequenceListUI.getStructuredSelection().getFirstElement();
                if (object instanceof ISequenceRecord) {
                    ISequenceRecord sequenceRecord = (ISequenceRecord)object;
                    ArrayList<File> files = new ArrayList<File>();
                    files.add(new File(String.valueOf(ExtendedSequenceListUI.this.sequence.getDataPath()) + File.separator + sequenceRecord.getDataFile()));
                    try {
                        ExtendedSequenceListUI.this.chromatogramTypeSupport.openFiles(files);
                    }
                    catch (Exception e1) {
                        ExtendedSequenceListUI.this.showDataPathWarningMessage(e.display.getActiveShell());
                        logger.warn((Object)e1);
                    }
                }
            }
        });
    }

    private void updateDataSequenceData() {
        if (this.sequence != null) {
            this.dataPath.setText(this.sequence.getDataPath());
            this.sequenceListUI.setInput(this.sequence);
        } else {
            this.dataPath.setText("");
            this.sequenceListUI.setInput(null);
        }
    }

    private void showDataPathWarningMessage(Shell shell) {
        MessageDialog.openWarning((Shell)shell, (String)"Open Chromatogram", (String)"The file doesn't exist. Please check that the data path is set correctly.");
    }
}

