/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.columns.ISeparationColumn;
import org.eclipse.chemclipse.model.columns.SeparationColumnFactory;
import org.eclipse.chemclipse.model.comparator.PeakRetentionTimeComparator;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.IChromatogramSelectionProcessSupplier;
import org.eclipse.chemclipse.model.support.IAnalysisSegment;
import org.eclipse.chemclipse.model.updates.IChromatogramSelectionUpdateListener;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.core.DefaultProcessingResult;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.processing.methods.ProcessEntryContainer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionConsumer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.support.ui.swt.EditorToolBar;
import org.eclipse.chemclipse.support.ui.swt.ProcessorToolbar;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.swt.ui.components.IMethodListener;
import org.eclipse.chemclipse.swt.ui.preferences.PreferencePageSWT;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.Fonts;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.actions.TargetLabelEditAction;
import org.eclipse.chemclipse.ux.extension.xxd.ui.calibration.RetentionIndexUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.ChartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.ChromatogramChart;
import org.eclipse.chemclipse.ux.extension.xxd.ui.editors.EditorProcessTypeSupplier;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.charts.TargetReferenceLabelMarker;
import org.eclipse.chemclipse.ux.extension.xxd.ui.methods.MethodSupportUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.methods.SettingsWizard;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferenceInitializer;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageChromatogram;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageChromatogramAxes;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageChromatogramPeaks;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageChromatogramScans;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageProcessors;
import org.eclipse.chemclipse.ux.extension.xxd.ui.segments.AnalysisSegmentColorScheme;
import org.eclipse.chemclipse.ux.extension.xxd.ui.segments.AnalysisSegmentPaintListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.DisplayType;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.PreferenceStoreTargetDisplaySettings;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.SignalTargetReference;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.TargetDisplaySettings;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.WorkspaceTargetDisplaySettings;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramChartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.PeakChartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ScanChartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ChromatogramReferencesUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.HeatmapUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ToolbarConfig;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ChromatogramAlignmentUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ChromatogramMoveArrowKeyHandler;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ChromatogramResetHandler;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ChromatogramSelectionHandler;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.PeakSelectionHandler;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ProcessorSupplierMenuEntry;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ScanSelectionArrowKeyHandler;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ScanSelectionHandler;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.IPeakWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.ChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.xxd.process.comparators.CategoryNameComparator;
import org.eclipse.chemclipse.xxd.process.support.ProcessTypeSupport;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.axisconverter.MillisecondsToScanNumberConverter;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ICustomSelectionHandler;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.core.SecondaryAxisSettings;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.menu.IChartMenuEntry;
import org.eclipse.swtchart.extensions.menu.ResetChartHandler;

public class ExtendedChromatogramUI
implements ToolbarConfig {
    public static final String PREFERENCE_SHOW_TOOLBAR_TEXT = "ChromatogramUI.showToolbarText";
    public static final String PREFERENCE_SHOW_LABELS_AT_TIC = "ChromatogramUI.showLabelsAtTic";
    private static final Logger logger = Logger.getLogger(ExtendedChromatogramUI.class);
    protected static final String TYPE_GENERIC = "TYPE_GENERIC";
    protected static final String TYPE_MSD = "TYPE_MSD";
    protected static final String TYPE_CSD = "TYPE_CSD";
    protected static final String TYPE_WSD = "TYPE_WSD";
    private String titleScans = Activator.getDefault().getPreferenceStore().getString("titleXAxisScans");
    private static final String LABEL_SCAN_NUMBER = "Scan Number";
    public static final String SERIES_ID_CHROMATOGRAM = "Chromatogram";
    private static final String SERIES_ID_BASELINE = "Baseline";
    private static final String SERIES_ID_PEAKS_NORMAL_ACTIVE = "Peak(s) [Active]";
    private static final String SERIES_ID_PEAKS_NORMAL_INACTIVE = "Peak(s) [Inactive]";
    private static final String SERIES_ID_PEAKS_ISTD_ACTIVE = "Peak(s) ISTD [Active]";
    private static final String SERIES_ID_PEAKS_ISTD_INACTIVE = "Peak(s) ISTD [Inactive]";
    private static final String SERIES_ID_SELECTED_PEAK_MARKER = "Selected Peak Marker";
    private static final String SERIES_ID_SELECTED_PEAK_SHAPE = "Selected Peak Shape";
    private static final String SERIES_ID_SELECTED_PEAK_BACKGROUND = "Selected Peak Background";
    private static final String SERIES_ID_SELECTED_SCAN = "Selected Scan";
    private static final String SERIES_ID_IDENTIFIED_SCANS = "Identified Scans";
    private static final String SERIES_ID_IDENTIFIED_SCAN_SELECTED = "Identified Scan Selected";
    private static final int THREE_MINUTES = 180000;
    private static final int FIVE_MINUTES = 300000;
    private static final String TOOLBAR_INFO = "TOOLBAR_INFO";
    private static final String TOOLBAR_RETENTION_INDICES = "TOOLBAR_RETENTION_INDICES";
    private static final String TOOLBAR_METHOD = "TOOLBAR_METHOD";
    private static final String TOOLBAR_CHROMATOGRAM_ALIGNMENT = "TOOLBAR_CHROMATOGRAM_ALIGNMENT";
    private static final String TOOLBAR_EDIT = "TOOLBAR_EDIT";
    private final Map<String, Composite> toolbars = new HashMap<String, Composite>();
    private EditorToolBar toolbarMain;
    private Label labelChromatogramInfo;
    private ChromatogramReferencesUI chromatogramReferencesUI;
    private RetentionIndexUI retentionIndexUI;
    private ChromatogramChart chromatogramChart;
    private ComboViewer comboViewerSeparationColumn;
    private HeatmapUI heatmapUI;
    private Composite heatmapArea;
    private IChromatogramSelection<?, ?> chromatogramSelection = null;
    private final List<IChartMenuEntry> cachedMenuEntries = new ArrayList<IChartMenuEntry>();
    private final Map<String, TargetReferenceLabelMarker> peakLabelMarkerMap = new HashMap<String, TargetReferenceLabelMarker>();
    private final Map<String, TargetReferenceLabelMarker> scanLabelMarkerMap = new HashMap<String, TargetReferenceLabelMarker>();
    private final PeakRetentionTimeComparator peakRetentionTimeComparator = new PeakRetentionTimeComparator(SortOrder.ASC);
    private final PeakChartSupport peakChartSupport = new PeakChartSupport();
    private final ScanChartSupport scanChartSupport = new ScanChartSupport();
    private final ChromatogramChartSupport chromatogramChartSupport = new ChromatogramChartSupport();
    private final ChartSupport chartSupport;
    private DisplayType displayType = DisplayType.TIC;
    private boolean suspendUpdate = false;
    private final IPreferenceStore preferenceStore;
    private final ProcessSupplierContext processTypeSupport;
    private final IEventBroker eventBroker;
    private MethodSupportUI methodSupportUI;
    private WorkspaceTargetDisplaySettings targetDisplaySettings;
    private Predicate<IProcessSupplier<?>> dataCategoryPredicate;
    private ProcessorToolbar processorToolbar;

    @Deprecated
    public ExtendedChromatogramUI(Composite parent, int style, IEventBroker eventBroker) {
        this(parent, style, eventBroker, Activator.getDefault().getPreferenceStore());
    }

    public ExtendedChromatogramUI(Composite parent, int style, IEventBroker eventBroker, ProcessSupplierContext supplierContext) {
        this(parent, style, eventBroker, supplierContext, Activator.getDefault().getPreferenceStore());
    }

    @Deprecated
    public ExtendedChromatogramUI(Composite parent, int style, IEventBroker eventBroker, IPreferenceStore store) {
        this(parent, style, eventBroker, (ProcessSupplierContext)new ProcessTypeSupport(), store);
    }

    public ExtendedChromatogramUI(Composite parent, int style, IEventBroker eventBroker, ProcessSupplierContext supplierContext, IPreferenceStore store) {
        this.eventBroker = eventBroker;
        this.processTypeSupport = supplierContext;
        this.preferenceStore = store;
        this.chartSupport = new ChartSupport(store);
        this.initialize(parent, style);
    }

    @Override
    public void setToolbarVisible(boolean visible) {
        this.toolbarMain.setVisible(visible);
    }

    @Override
    public boolean isToolbarVisible() {
        return this.toolbarMain.isVisible();
    }

    public void fireUpdate(Display display) {
        this.fireUpdateChromatogram(display);
        if (!this.fireUpdatePeak(display)) {
            this.fireUpdateScan(display);
        }
    }

    public boolean fireUpdateChromatogram(Display display) {
        final IChromatogramSelection chromatogramSelection = this.getChromatogramSelection();
        if (chromatogramSelection != null && this.eventBroker != null && display != null) {
            if (this.preferenceStore.getBoolean("legacyUpdateChromatogramModus")) {
                this.fireUpdateChromatogramLegacy(display);
            }
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ExtendedChromatogramUI.this.eventBroker.send("chromatogram/xxd/load/chromatogramselection", (Object)chromatogramSelection);
                }
            });
        }
        return chromatogramSelection != null;
    }

    private void fireUpdateChromatogramLegacy(Display display) {
        final HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChromatogramSelection", this.chromatogramSelection);
        map.put("ForceReload", true);
        final String topic = this.chromatogramSelection instanceof IChromatogramSelectionMSD ? "chromatogram/msd/update/chromatogramselection" : (this.chromatogramSelection instanceof IChromatogramSelectionCSD ? "chromatogram/csd/update/chromatogramselection" : (this.chromatogramSelection instanceof IChromatogramSelectionWSD ? "chromatogram/wsd/update/chromatogramselection" : null));
        if (topic != null && this.eventBroker != null && display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ExtendedChromatogramUI.this.eventBroker.post(topic, (Object)map);
                }
            });
        }
    }

    public boolean fireUpdatePeak(Display display) {
        IPeak peak;
        boolean update = false;
        IChromatogramSelection chromatogramSelection = this.getChromatogramSelection();
        if (chromatogramSelection != null && this.eventBroker != null && display != null && (peak = chromatogramSelection.getSelectedPeak()) != null) {
            if (this.preferenceStore.getBoolean("legacyUpdatePeakModus")) {
                this.fireUpdatePeakLegacy(peak, display);
            }
            update = true;
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ExtendedChromatogramUI.this.eventBroker.send("peak/xxd/update/selection", (Object)peak);
                }
            });
        }
        return update;
    }

    private void fireUpdatePeakLegacy(IPeak peak, Display display) {
        if (peak != null && this.eventBroker != null && display != null) {
            final HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("PeakMSD", peak);
            map.put("ForceReload", true);
            final String topic = peak instanceof IPeakMSD ? "chromatogram/msd/update/peak" : (peak instanceof IPeakCSD ? "chromatogram/csd/update/peak" : (peak instanceof IPeakWSD ? "chromatogram/wsd/update/peak" : null));
            if (topic != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ExtendedChromatogramUI.this.eventBroker.post(topic, (Object)map);
                    }
                });
            }
        }
    }

    public boolean fireUpdateScan(Display display) {
        IScan scan;
        boolean update = false;
        IChromatogramSelection chromatogramSelection = this.getChromatogramSelection();
        if (chromatogramSelection != null && this.eventBroker != null && display != null && (scan = chromatogramSelection.getSelectedScan()) != null) {
            update = true;
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ExtendedChromatogramUI.this.eventBroker.post("scan/xxd/update/selection", (Object)scan);
                }
            });
        }
        return update;
    }

    public ChromatogramChart getChromatogramChart() {
        return this.chromatogramChart;
    }

    public synchronized void updateChromatogramSelection(IChromatogramSelection chromatogramSelection) {
        this.setChromatogramSelectionInternal(chromatogramSelection);
        this.chromatogramReferencesUI.setMasterChromatogram(chromatogramSelection);
    }

    private void setChromatogramSelectionInternal(IChromatogramSelection chromatogramSelection) {
        if (this.chromatogramSelection != chromatogramSelection) {
            DataCategory datatype = DataCategory.AUTO_DETECT;
            if (chromatogramSelection != null) {
                IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                if (chromatogram instanceof IChromatogramMSD) {
                    datatype = DataCategory.MSD;
                } else if (chromatogram instanceof IChromatogramWSD) {
                    datatype = DataCategory.WSD;
                } else if (chromatogram instanceof IChromatogramCSD) {
                    datatype = DataCategory.CSD;
                }
            }
            this.dataCategoryPredicate = ProcessSupplierContext.createDataCategoryPredicate((DataCategory[])new DataCategory[]{datatype});
            this.targetDisplaySettings = null;
            this.chromatogramSelection = chromatogramSelection;
            this.updateToolbar(this.toolbars.get(TOOLBAR_CHROMATOGRAM_ALIGNMENT), chromatogramSelection);
            if (chromatogramSelection != null) {
                this.adjustAxisSettings();
                this.updateMenu(true);
                this.updateChromatogram();
                this.setSeparationColumnSelection();
                this.retentionIndexUI.setInput(chromatogramSelection.getChromatogram().getSeparationColumnIndices());
            } else {
                this.retentionIndexUI.setInput(null);
                this.updateChromatogram();
            }
            this.processorToolbar.update();
            this.fireUpdate(this.getChromatogramChart().getDisplay());
        }
    }

    public void update() {
        if (!this.suspendUpdate) {
            this.updateChromatogram();
            this.adjustChromatogramSelectionRange();
            this.setSeparationColumnSelection();
        }
    }

    public void updateSelectedScan() {
        this.chromatogramChart.deleteSeries(SERIES_ID_SELECTED_SCAN);
        this.chromatogramChart.deleteSeries(SERIES_ID_IDENTIFIED_SCAN_SELECTED);
        ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
        this.addSelectedScanData(lineSeriesDataList);
        this.addSelectedIdentifiedScanData(lineSeriesDataList);
        this.addLineSeriesData(lineSeriesDataList);
        this.adjustChromatogramSelectionRange();
    }

    public void updateSelectedPeak() {
        this.chromatogramChart.deleteSeries(SERIES_ID_SELECTED_PEAK_MARKER);
        this.chromatogramChart.deleteSeries(SERIES_ID_SELECTED_PEAK_SHAPE);
        this.chromatogramChart.deleteSeries(SERIES_ID_SELECTED_PEAK_BACKGROUND);
        ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
        this.addSelectedPeakData(lineSeriesDataList, this.getTargetSettings());
        this.addLineSeriesData(lineSeriesDataList);
        this.adjustChromatogramSelectionRange();
    }

    public IChromatogramSelection getChromatogramSelection() {
        return this.chromatogramSelection;
    }

    public boolean isActiveChromatogramSelection(IChromatogramSelection chromatogramSelection) {
        return this.chromatogramSelection == chromatogramSelection;
    }

    protected void setChromatogramSelectionRange(int startRetentionTime, int stopRetentionTime, float startAbundance, float stopAbundance) {
        this.chromatogramSelection.setRanges(startRetentionTime, stopRetentionTime, startAbundance, stopAbundance, false);
        this.suspendUpdate = true;
        this.chromatogramSelection.update(true);
        this.suspendUpdate = false;
        this.adjustChromatogramSelectionRange();
    }

    protected void updateSelection() {
        if (this.chromatogramSelection != null) {
            this.chromatogramSelection.update(true);
            this.adjustChromatogramSelectionRange();
        }
    }

    @Deprecated
    protected void processChromatogram(IRunnableWithProgress runnable) {
        this.processChromatogram(runnable, DisplayUtils.getShell());
    }

    protected void processChromatogram(IRunnableWithProgress runnable, Shell shell) {
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(shell);
        try {
            monitor.run(true, true, runnable);
            if (this.chromatogramSelection != null) {
                this.chromatogramSelection.getChromatogram().setDirty(true);
            }
            this.updateChromatogram();
            this.updateSelection();
            this.chromatogramReferencesUI.update();
            this.fireUpdate(shell.getDisplay());
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void adjustMinuteScale() {
        if (this.chromatogramSelection != null) {
            int startRetentionTime = this.chromatogramSelection.getStartRetentionTime();
            int stopRetentionTime = this.chromatogramSelection.getStopRetentionTime();
            int deltaRetentionTime = stopRetentionTime - startRetentionTime + 1;
            IChartSettings chartSettings = this.chromatogramChart.getChartSettings();
            List axisSettings = chartSettings.getSecondaryAxisSettingsListX();
            for (ISecondaryAxisSettings axisSetting : axisSettings) {
                if (!axisSetting.getTitle().equals("Minutes")) continue;
                if (deltaRetentionTime >= 300000) {
                    axisSetting.setDecimalFormat(new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH)));
                    continue;
                }
                if (deltaRetentionTime >= 180000) {
                    axisSetting.setDecimalFormat(new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.ENGLISH)));
                    continue;
                }
                axisSetting.setDecimalFormat(new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.ENGLISH)));
            }
            this.chromatogramChart.applySettings(chartSettings);
        }
    }

    public void updateMenu() {
        this.updateMenu(false);
    }

    public void updateMenu(boolean force) {
        if (this.processTypeSupport != null) {
            IChartSettings chartSettings = this.chromatogramChart.getChartSettings();
            for (IChartMenuEntry cachedEntry : this.cachedMenuEntries) {
                chartSettings.removeMenuEntry(cachedEntry);
            }
            this.cachedMenuEntries.clear();
            ArrayList suplierList = new ArrayList(this.processTypeSupport.getSupplier(this::isValidSupplier));
            Collections.sort(suplierList, new CategoryNameComparator());
            for (IProcessSupplier supplier : suplierList) {
                ProcessorSupplierMenuEntry cachedEntry = new ProcessorSupplierMenuEntry(supplier, this.processTypeSupport, this::executeSupplier);
                this.cachedMenuEntries.add(cachedEntry);
                chartSettings.addMenuEntry(cachedEntry);
            }
            this.chromatogramChart.applySettings(chartSettings);
        }
    }

    private <C> void executeSupplier(IProcessSupplier<C> processSupplier, final ProcessSupplierContext processSupplierContext) {
        final Shell shell = this.getChromatogramChart().getShell();
        try {
            final ProcessorPreferences<C> settings = SettingsWizard.getSettings(shell, SettingsWizard.getWorkspacePreferences(processSupplier));
            if (settings == null) {
                return;
            }
            this.processChromatogram(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DefaultProcessingResult msgs = new DefaultProcessingResult();
                    IProcessSupplier.applyProcessor((ProcessorPreferences)settings, (ProcessExecutionConsumer)IChromatogramSelectionProcessSupplier.createConsumer((IChromatogramSelection)ExtendedChromatogramUI.this.getChromatogramSelection()), (ProcessExecutionContext)new ProcessExecutionContext(monitor, (MessageConsumer)msgs, processSupplierContext));
                    ExtendedChromatogramUI.this.updateResult(shell, (MessageProvider)msgs);
                }
            }, shell);
        }
        catch (IOException e) {
            DefaultProcessingResult result = new DefaultProcessingResult();
            result.addErrorMessage(processSupplier.getName(), "can't process settings", (Throwable)e);
            this.updateResult(shell, (MessageProvider)result);
        }
    }

    public void updateResult(Shell shell, MessageProvider result) {
        if (result != null) {
            shell.getDisplay().asyncExec(() -> ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)result, (boolean)result.hasErrorMessages()));
        }
    }

    private boolean isValidSupplier(IProcessSupplier<?> supplier) {
        if (supplier.getType() == IProcessSupplier.SupplierType.STRUCTURAL) {
            return false;
        }
        if (supplier.getTypeSupplier() instanceof EditorProcessTypeSupplier) {
            return false;
        }
        return this.dataCategoryPredicate != null && this.dataCategoryPredicate.test(supplier);
    }

    private void updateChromatogram() {
        this.updateLabel();
        this.clearPeakAndScanLabels();
        this.adjustMinuteScale();
        this.deleteScanNumberSecondaryAxisX();
        this.chromatogramChart.deleteSeries();
        if (this.chromatogramSelection != null) {
            this.addjustChromatogramChart();
            this.addChromatogramSeriesData(this.getTargetSettings());
            this.adjustChromatogramSelectionRange();
        }
    }

    private TargetDisplaySettings getTargetSettings() {
        TargetDisplaySettings displaySettings = (TargetDisplaySettings)Adapters.adapt(this.chromatogramSelection, TargetDisplaySettings.class);
        if (displaySettings != null) {
            return displaySettings;
        }
        if (this.targetDisplaySettings == null) {
            File chromatogramFile = this.chromatogramSelection != null ? this.chromatogramSelection.getChromatogram().getFile() : null;
            this.targetDisplaySettings = WorkspaceTargetDisplaySettings.getWorkspaceSettings(chromatogramFile, PreferenceStoreTargetDisplaySettings.getSettings(this.preferenceStore));
        }
        return this.targetDisplaySettings;
    }

    private void clearPeakAndScanLabels() {
        for (String key : this.peakLabelMarkerMap.keySet()) {
            this.removeIdentificationLabelMarker(this.peakLabelMarkerMap, key);
        }
        for (String key : this.scanLabelMarkerMap.keySet()) {
            this.removeIdentificationLabelMarker(this.scanLabelMarkerMap, key);
        }
        this.peakLabelMarkerMap.clear();
        this.scanLabelMarkerMap.clear();
    }

    private void removeIdentificationLabelMarker(Map<String, ? extends ICustomPaintListener> markerMap, String seriesId) {
        IPlotArea plotArea = this.chromatogramChart.getBaseChart().getPlotArea();
        ICustomPaintListener labelMarker = markerMap.get(seriesId);
        if (labelMarker != null) {
            plotArea.removeCustomPaintListener(labelMarker);
        }
    }

    private void addjustChromatogramChart() {
        IChartSettings chartSettings = this.chromatogramChart.getChartSettings();
        RangeRestriction rangeRestriction = chartSettings.getRangeRestriction();
        double extendX = this.preferenceStore.getDouble("chromatogramExtendX");
        rangeRestriction.setExtendMaxY(extendX);
        if (this.chromatogramSelection instanceof IChromatogramSelectionMSD) {
            rangeRestriction.setZeroY(true);
            rangeRestriction.setForceZeroMinY(this.preferenceStore.getBoolean("chromatogramForceZeroMinYMSD"));
        } else if (this.chromatogramSelection instanceof IChromatogramSelectionCSD || this.chromatogramSelection instanceof IChromatogramSelectionWSD) {
            rangeRestriction.setZeroY(false);
            rangeRestriction.setForceZeroMinY(false);
        }
        rangeRestriction.setXZoomOnly(this.preferenceStore.getBoolean("chromatogramXZoomOnly"));
        rangeRestriction.setYZoomOnly(this.preferenceStore.getBoolean("chromatogramYZoomOnly"));
        this.chromatogramChart.applySettings(chartSettings);
    }

    private void addChromatogramSeriesData(TargetDisplaySettings settings) {
        ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
        this.addChromatogramData(lineSeriesDataList);
        this.addPeakData(lineSeriesDataList, settings);
        this.addIdentifiedScansData(lineSeriesDataList, settings);
        this.addSelectedPeakData(lineSeriesDataList, settings);
        this.addSelectedScanData(lineSeriesDataList);
        this.addSelectedIdentifiedScanData(lineSeriesDataList);
        this.addBaselineData(lineSeriesDataList);
        this.addLineSeriesData(lineSeriesDataList);
    }

    private void addChromatogramData(List<ILineSeriesData> lineSeriesDataList) {
        Color color = Colors.getColor((String)this.preferenceStore.getString("colorChromatogram"));
        boolean enableChromatogramArea = this.preferenceStore.getBoolean("enableChromatogramArea");
        ILineSeriesData lineSeriesData = this.chromatogramChartSupport.getLineSeriesData(this.chromatogramSelection, SERIES_ID_CHROMATOGRAM, this.displayType, color, false);
        lineSeriesData.getSettings().setEnableArea(enableChromatogramArea);
        lineSeriesDataList.add(lineSeriesData);
    }

    private void addPeakData(List<ILineSeriesData> lineSeriesDataList, TargetDisplaySettings settings) {
        if (this.chromatogramSelection != null) {
            IChromatogram chromatogram = this.chromatogramSelection.getChromatogram();
            int symbolSize = this.preferenceStore.getInt("chromatogramPeakLabelSymbolSize");
            ILineSeries.PlotSymbolType symbolTypeActiveNormal = ILineSeries.PlotSymbolType.valueOf((String)this.preferenceStore.getString("chromatogramPeaksActiveNormalMarkerType"));
            ILineSeries.PlotSymbolType symbolTypeInactiveNormal = ILineSeries.PlotSymbolType.valueOf((String)this.preferenceStore.getString("chromatogramPeaksInactiveNormalMarkerType"));
            ILineSeries.PlotSymbolType symbolTypeActiveIstd = ILineSeries.PlotSymbolType.valueOf((String)this.preferenceStore.getString("chromatogramPeaksActiveIstdMarkerType"));
            ILineSeries.PlotSymbolType symbolTypeInactiveIstd = ILineSeries.PlotSymbolType.valueOf((String)this.preferenceStore.getString("chromatogramPeaksInactiveIstdMarkerType"));
            List<IPeak> peaks = ChromatogramDataSupport.getPeaks(chromatogram);
            ArrayList<IPeak> peaksActiveNormal = new ArrayList<IPeak>();
            ArrayList<IPeak> peaksInactiveNormal = new ArrayList<IPeak>();
            ArrayList<IPeak> peaksActiveISTD = new ArrayList<IPeak>();
            ArrayList<IPeak> peaksInactiveISTD = new ArrayList<IPeak>();
            for (IPeak peak : peaks) {
                if (peak.getInternalStandards().size() > 0) {
                    if (peak.isActiveForAnalysis()) {
                        peaksActiveISTD.add(peak);
                        continue;
                    }
                    peaksInactiveISTD.add(peak);
                    continue;
                }
                if (peak.isActiveForAnalysis()) {
                    peaksActiveNormal.add(peak);
                    continue;
                }
                peaksInactiveNormal.add(peak);
            }
            this.addPeaks(lineSeriesDataList, peaksActiveNormal, symbolTypeActiveNormal, symbolSize, Colors.DARK_GRAY, SERIES_ID_PEAKS_NORMAL_ACTIVE, settings);
            this.addPeaks(lineSeriesDataList, peaksInactiveNormal, symbolTypeInactiveNormal, symbolSize, Colors.GRAY, SERIES_ID_PEAKS_NORMAL_INACTIVE, settings);
            this.addPeaks(lineSeriesDataList, peaksActiveISTD, symbolTypeActiveIstd, symbolSize, Colors.RED, SERIES_ID_PEAKS_ISTD_ACTIVE, settings);
            this.addPeaks(lineSeriesDataList, peaksInactiveISTD, symbolTypeInactiveIstd, symbolSize, Colors.GRAY, SERIES_ID_PEAKS_ISTD_INACTIVE, settings);
        }
    }

    private void addPeaks(List<ILineSeriesData> lineSeriesDataList, List<IPeak> peaks, ILineSeries.PlotSymbolType plotSymbolType, int symbolSize, Color symbolColor, String seriesId, TargetDisplaySettings displaySettings) {
        if (peaks.size() > 0) {
            Collections.sort(peaks, this.peakRetentionTimeComparator);
            ILineSeriesData lineSeriesData = this.peakChartSupport.getPeaks(peaks, true, false, symbolColor, seriesId);
            ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
            lineSeriesSettings.setEnableArea(false);
            lineSeriesSettings.setLineStyle(LineStyle.NONE);
            lineSeriesSettings.setSymbolType(plotSymbolType);
            lineSeriesSettings.setSymbolSize(symbolSize);
            lineSeriesSettings.setSymbolColor(symbolColor);
            lineSeriesDataList.add(lineSeriesData);
            this.removeIdentificationLabelMarker(this.peakLabelMarkerMap, seriesId);
            if (displaySettings.isShowPeakLabels()) {
                IChromatogramSelection selection = this.getChromatogramSelection();
                BaseChart baseChart = this.chromatogramChart.getBaseChart();
                IPlotArea plotArea = baseChart.getPlotArea();
                boolean showAtTic = this.preferenceStore != null && this.preferenceStore.getBoolean(PREFERENCE_SHOW_LABELS_AT_TIC);
                List<SignalTargetReference> peakReferences = showAtTic ? SignalTargetReference.getPeakReferences(peaks, peak -> {
                    if (selection != null) {
                        IChromatogram chromatogram = selection.getChromatogram();
                        int scanNumber = chromatogram.getScanNumber(peak.getPeakModel().getRetentionTimeAtPeakMaximum());
                        return chromatogram.getScan(scanNumber);
                    }
                    return null;
                }) : SignalTargetReference.getPeakReferences(peaks);
                TargetReferenceLabelMarker peakLabelMarker = new TargetReferenceLabelMarker(baseChart, peakReferences, displaySettings, symbolSize * 2, this.preferenceStore);
                plotArea.addCustomPaintListener((ICustomPaintListener)peakLabelMarker);
                this.peakLabelMarkerMap.put(seriesId, peakLabelMarker);
            }
        }
    }

    private void addIdentifiedScansData(List<ILineSeriesData> lineSeriesDataList, TargetDisplaySettings displaySettings) {
        if (this.chromatogramSelection != null) {
            String seriesId = SERIES_ID_IDENTIFIED_SCANS;
            List<IScan> scans = ChromatogramDataSupport.getIdentifiedScans(this.chromatogramSelection.getChromatogram());
            int symbolSize = this.preferenceStore.getInt("chromatogramScanLabelSymbolSize");
            ILineSeries.PlotSymbolType symbolType = ILineSeries.PlotSymbolType.valueOf((String)this.preferenceStore.getString("chromatogramScanMarkerType"));
            this.addIdentifiedScansData(lineSeriesDataList, scans, symbolType, symbolSize, Colors.DARK_GRAY, seriesId);
            this.removeIdentificationLabelMarker(this.scanLabelMarkerMap, seriesId);
            if (displaySettings.isShowScanLables()) {
                BaseChart baseChart = this.chromatogramChart.getBaseChart();
                IPlotArea plotArea = baseChart.getPlotArea();
                TargetReferenceLabelMarker scanLabelMarker = new TargetReferenceLabelMarker(baseChart, SignalTargetReference.getScanReferences(scans), displaySettings, symbolSize * 2, this.preferenceStore);
                plotArea.addCustomPaintListener((ICustomPaintListener)scanLabelMarker);
                this.scanLabelMarkerMap.put(seriesId, scanLabelMarker);
            }
        }
    }

    private void addIdentifiedScansData(List<ILineSeriesData> lineSeriesDataList, List<IScan> scans, ILineSeries.PlotSymbolType plotSymbolType, int symbolSize, Color symbolColor, String seriesId) {
        if (scans.size() > 0) {
            ILineSeriesData lineSeriesData = null;
            lineSeriesData = this.scanChartSupport.getLineSeriesDataPoint(scans, false, seriesId, this.displayType, this.chromatogramSelection);
            ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
            lineSeriesSettings.setLineStyle(LineStyle.NONE);
            lineSeriesSettings.setSymbolType(plotSymbolType);
            lineSeriesSettings.setSymbolSize(symbolSize);
            lineSeriesSettings.setSymbolColor(symbolColor);
            lineSeriesDataList.add(lineSeriesData);
        }
    }

    private void addSelectedIdentifiedScanData(List<ILineSeriesData> lineSeriesDataList) {
        IScan scan;
        if (this.chromatogramSelection != null && (scan = this.chromatogramSelection.getSelectedIdentifiedScan()) != null) {
            String seriesId = SERIES_ID_IDENTIFIED_SCAN_SELECTED;
            Color color = Colors.getColor((String)this.preferenceStore.getString("colorChromatogramIdentifiedScan"));
            ILineSeries.PlotSymbolType symbolType = ILineSeries.PlotSymbolType.valueOf((String)this.preferenceStore.getString("chromatogramIdentifiedScanMarkerType"));
            int symbolSize = this.preferenceStore.getInt("chromatogramScanLabelSymbolSize");
            ArrayList<IScan> scans = new ArrayList<IScan>();
            scans.add(scan);
            this.addIdentifiedScansData(lineSeriesDataList, scans, symbolType, symbolSize, color, seriesId);
        }
    }

    private void addSelectedPeakData(List<ILineSeriesData> lineSeriesDataList, TargetDisplaySettings settings) {
        IPeak peak = this.chromatogramSelection.getSelectedPeak();
        if (peak != null) {
            boolean mirrored = false;
            Color colorPeak = Colors.getColor((String)this.preferenceStore.getString("colorChromatogramSelectedPeak"));
            int symbolSize = this.preferenceStore.getInt("chromatogramPeakLabelSymbolSize");
            ILineSeries.PlotSymbolType symbolTypePeakMarker = ILineSeries.PlotSymbolType.valueOf((String)this.preferenceStore.getString("chromatogramSelectedPeakMarkerType"));
            int scanMarkerSize = this.preferenceStore.getInt("showChromatogramSelectedPeakScanMarkerSize");
            ILineSeries.PlotSymbolType symbolTypeScanMarker = ILineSeries.PlotSymbolType.valueOf((String)this.preferenceStore.getString("showChromatogramSelectedPeakScanMarkerType"));
            ArrayList<IPeak> peaks = new ArrayList<IPeak>();
            peaks.add(peak);
            this.addPeaks(lineSeriesDataList, peaks, symbolTypePeakMarker, symbolSize, colorPeak, SERIES_ID_SELECTED_PEAK_MARKER, settings);
            ILineSeriesData lineSeriesData = this.peakChartSupport.getPeak(peak, true, mirrored, colorPeak, SERIES_ID_SELECTED_PEAK_SHAPE);
            ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
            lineSeriesSettings.setSymbolType(symbolTypeScanMarker);
            lineSeriesSettings.setSymbolColor(colorPeak);
            lineSeriesSettings.setSymbolSize(scanMarkerSize);
            lineSeriesDataList.add(lineSeriesData);
            Color colorBackground = Colors.getColor((String)this.preferenceStore.getString("colorPeakBackground"));
            lineSeriesData = this.peakChartSupport.getPeakBackground(peak, mirrored, colorBackground, SERIES_ID_SELECTED_PEAK_BACKGROUND);
            lineSeriesDataList.add(lineSeriesData);
        }
    }

    private void addSelectedScanData(List<ILineSeriesData> lineSeriesDataList) {
        IScan scan = this.chromatogramSelection.getSelectedScan();
        if (scan != null) {
            Color color = Colors.getColor((String)this.preferenceStore.getString("colorChromatogramSelectedScan"));
            int markerSize = this.preferenceStore.getInt("showChromatogramSelectedScanMarkerSize");
            ILineSeries.PlotSymbolType symbolType = ILineSeries.PlotSymbolType.valueOf((String)this.preferenceStore.getString("showChromatogramSelectedScanMarkerType"));
            ILineSeriesData lineSeriesData = this.scanChartSupport.getLineSeriesDataPoint(scan, false, SERIES_ID_SELECTED_SCAN, this.displayType, this.chromatogramSelection);
            ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
            lineSeriesSettings.setLineStyle(LineStyle.NONE);
            lineSeriesSettings.setSymbolType(symbolType);
            lineSeriesSettings.setSymbolSize(markerSize);
            lineSeriesSettings.setSymbolColor(color);
            lineSeriesDataList.add(lineSeriesData);
        }
    }

    private void addBaselineData(List<ILineSeriesData> lineSeriesDataList) {
        boolean showChromatogramBaseline = this.preferenceStore.getBoolean("showChromatogramBaseline");
        if (this.chromatogramSelection != null && showChromatogramBaseline) {
            Color color = Colors.getColor((String)this.preferenceStore.getString("colorChromatogramBaseline"));
            boolean enableBaselineArea = this.preferenceStore.getBoolean("enableBaselineArea");
            ILineSeriesData lineSeriesData = null;
            lineSeriesData = this.chromatogramChartSupport.getLineSeriesDataBaseline(this.chromatogramSelection, SERIES_ID_BASELINE, this.displayType, color, false);
            lineSeriesData.getSettings().setEnableArea(enableBaselineArea);
            lineSeriesDataList.add(lineSeriesData);
        }
    }

    private void addLineSeriesData(List<ILineSeriesData> lineSeriesDataList) {
        String compressionType = this.preferenceStore.getString("chromatogramChartCompressionType");
        int compressionToLength = this.chromatogramChartSupport.getCompressionLength(compressionType, lineSeriesDataList.size());
        this.chromatogramChart.addSeriesData(lineSeriesDataList, compressionToLength);
    }

    private void initialize(Composite parent, int style) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.toolbarMain = this.createToolbarMain(parent);
        this.toolbars.put(TOOLBAR_INFO, this.createToolbarInfo(parent));
        this.toolbars.put(TOOLBAR_EDIT, this.createToolbarEdit(parent));
        this.toolbars.put(TOOLBAR_CHROMATOGRAM_ALIGNMENT, this.createChromatogramAlignmentUI(parent));
        this.toolbars.put(TOOLBAR_METHOD, this.createToolbarMethod(parent));
        this.retentionIndexUI = this.createToolbarRetentionIndexUI(parent);
        this.toolbars.put(TOOLBAR_RETENTION_INDICES, this.retentionIndexUI);
        SashForm chartsArea = new SashForm(parent, 256);
        chartsArea.setLayoutData((Object)new GridData(1808));
        this.createChromatogramChart((Composite)chartsArea, style);
        this.createHeatmap((Composite)chartsArea);
        this.comboViewerSeparationColumn.setInput((Object)SeparationColumnFactory.getSeparationColumns());
        PartSupport.setCompositeVisibility((Composite)this.toolbars.get(TOOLBAR_INFO), (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbars.get(TOOLBAR_EDIT), (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbars.get(TOOLBAR_CHROMATOGRAM_ALIGNMENT), (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbars.get(TOOLBAR_METHOD), (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbars.get(TOOLBAR_RETENTION_INDICES), (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.heatmapArea, (boolean)false);
    }

    private EditorToolBar createToolbarMain(Composite parent) {
        EditorToolBar editorToolBar = new EditorToolBar(parent);
        this.processorToolbar = new ProcessorToolbar(editorToolBar, this.processTypeSupport, this::isValidSupplier, this::executeSupplier);
        editorToolBar.addAction((IAction)this.createLabelsAction());
        editorToolBar.addAction(this.createToggleToolbarAction("Info", "the info toolbar.", "org.eclipse.chemclipse.rcp.ui.icons/info.gif", TOOLBAR_INFO));
        editorToolBar.createCombo(this::initComboViewerSeparationColumn, true, 150);
        this.chromatogramReferencesUI = new ChromatogramReferencesUI(editorToolBar, this::setChromatogramSelectionInternal);
        editorToolBar.addAction(this.createToggleToolbarAction("Edit", "the edit toolbar.", "org.eclipse.chemclipse.rcp.ui.icons/edit.gif", TOOLBAR_EDIT));
        editorToolBar.addAction(this.createToggleToolbarAction("Alignment", "the chromatogram alignment toolbar.", "org.eclipse.chemclipse.rcp.ui.icons/alignChromatograms.gif", TOOLBAR_CHROMATOGRAM_ALIGNMENT));
        editorToolBar.addAction(this.createToggleToolbarAction("Methods", "the method toolbar.", "org.eclipse.chemclipse.rcp.ui.icons/method.gif", TOOLBAR_METHOD));
        this.createResetButton(editorToolBar);
        editorToolBar.enableToolbarTextPage(this.preferenceStore, PREFERENCE_SHOW_TOOLBAR_TEXT);
        this.processorToolbar.enablePreferencePage(this.preferenceStore, "ProcessorToolbar.Processors");
        editorToolBar.addPreferencePages((Supplier)new Supplier<Collection<? extends IPreferencePage>>(){

            @Override
            public Collection<? extends IPreferencePage> get() {
                PreferencePageProcessors processorsPage = new PreferencePageProcessors(ExtendedChromatogramUI.this.processTypeSupport);
                PreferencePageChromatogram preferencePageChromatogram = new PreferencePageChromatogram(ExtendedChromatogramUI.this.preferenceStore);
                preferencePageChromatogram.setTitle("Chromatogram Settings");
                PreferencePageChromatogramAxes preferencePageChromatogramAxes = new PreferencePageChromatogramAxes(ExtendedChromatogramUI.this.preferenceStore);
                preferencePageChromatogramAxes.setTitle("Chromatogram Axes");
                PreferencePageChromatogramPeaks preferencePageChromatogramPeaks = new PreferencePageChromatogramPeaks(ExtendedChromatogramUI.this.preferenceStore, new String[0]);
                preferencePageChromatogramPeaks.setTitle("Chromatogram Peaks");
                PreferencePageChromatogramScans preferencePageChromatogramScans = new PreferencePageChromatogramScans(ExtendedChromatogramUI.this.preferenceStore);
                preferencePageChromatogramScans.setTitle("Chromatogram Scans");
                PreferencePageSWT preferencePageSWT = new PreferencePageSWT();
                preferencePageSWT.setTitle("Settings (SWT)");
                return Arrays.asList(new IPreferencePage[]{processorsPage, preferencePageChromatogram, preferencePageChromatogramAxes, preferencePageChromatogramPeaks, preferencePageChromatogramScans, preferencePageSWT});
            }
        }, this::applySettings);
        return editorToolBar;
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelChromatogramInfo = new Label(composite, 0);
        this.labelChromatogramInfo.setText("");
        this.labelChromatogramInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private RetentionIndexUI createToolbarRetentionIndexUI(Composite parent) {
        RetentionIndexUI retentionIndexUI = new RetentionIndexUI(parent, 0);
        retentionIndexUI.setLayoutData(new GridData(1808));
        retentionIndexUI.setSearchVisibility(false);
        return retentionIndexUI;
    }

    private Composite createToolbarMethod(final Composite parent) {
        this.methodSupportUI = new MethodSupportUI(parent, 0);
        this.methodSupportUI.setLayoutData(new GridData(768));
        this.methodSupportUI.setMethodListener(new IMethodListener(){

            public void execute(IProcessMethod processMethod, IProgressMonitor monitor) {
                ProcessingInfo processingInfo = new ProcessingInfo();
                IChromatogramSelection selection = ExtendedChromatogramUI.this.getChromatogramSelection();
                ProcessEntryContainer.applyProcessEntries((ProcessEntryContainer)processMethod, (ProcessExecutionContext)new ProcessExecutionContext(monitor, (MessageConsumer)processingInfo, ExtendedChromatogramUI.this.processTypeSupport), (ProcessExecutionConsumer)IChromatogramSelectionProcessSupplier.createConsumer((IChromatogramSelection)selection));
                selection.update(false);
                ExtendedChromatogramUI.this.updateResult(parent.getShell(), (MessageProvider)processingInfo);
            }
        });
        this.toolbarMain.addPreferencePages(() -> Arrays.asList(this.methodSupportUI.getPreferencePages()), this.methodSupportUI::applySettings);
        return this.methodSupportUI;
    }

    private ChromatogramAlignmentUI createChromatogramAlignmentUI(Composite parent) {
        ChromatogramAlignmentUI composite = new ChromatogramAlignmentUI(parent, 0);
        composite.setLayoutData(new GridData(768));
        return composite;
    }

    private void initComboViewerSeparationColumn(final ComboViewer comboViewer) {
        this.comboViewerSeparationColumn = comboViewer;
        Control combo = comboViewer.getControl();
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ISeparationColumn) {
                    ISeparationColumn separationColumn = (ISeparationColumn)element;
                    return separationColumn.getName();
                }
                return null;
            }
        });
        combo.setToolTipText("Select a chromatogram column.");
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof ISeparationColumn && ExtendedChromatogramUI.this.chromatogramSelection != null) {
                    ISeparationColumn separationColumn = (ISeparationColumn)object;
                    ExtendedChromatogramUI.this.chromatogramSelection.getChromatogram().getSeparationColumnIndices().setSeparationColumn(separationColumn);
                    ExtendedChromatogramUI.this.updateLabel();
                }
            }
        });
    }

    private Composite createToolbarEdit(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(7, false));
        this.createToggleToolbarButton(composite, "Toggle the retention index toolbar.", "org.eclipse.chemclipse.rcp.ui.icons/retentionIndex.gif", TOOLBAR_RETENTION_INDICES);
        this.createVerticalSeparator(composite);
        this.createToggleChartSeriesLegendButton(composite);
        this.createToggleLegendMarkerButton(composite);
        this.createToggleRangeSelectorButton(composite);
        this.createVerticalSeparator(composite);
        this.createButtonSignalSelection(composite);
        return composite;
    }

    private void createButtonSignalSelection(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Select signal");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/heatmapDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedChromatogramUI.this.signalSelectionHeatMap();
            }
        });
    }

    private void signalSelectionHeatMap() {
        PartSupport.setCompositeVisibility((Composite)this.heatmapArea, (!this.heatmapArea.getVisible() ? 1 : 0) != 0);
        this.heatmapUI.setChromatogramSelection(this.chromatogramSelection);
        if (this.chromatogramSelection instanceof ChromatogramSelectionWSD) {
            if (this.displayType.equals((Object)DisplayType.SWC)) {
                this.displayType = DisplayType.TIC;
                this.update();
            } else if (this.displayType.equals((Object)DisplayType.TIC)) {
                this.displayType = DisplayType.SWC;
                this.update();
            }
        }
    }

    private void createVerticalSeparator(Composite parent) {
        Label label = new Label(parent, 514);
        GridData gridData = new GridData();
        gridData.heightHint = 35;
        label.setLayoutData((Object)gridData);
    }

    private void createChromatogramChart(Composite parent, int style) {
        this.chromatogramChart = new ChromatogramChart(parent, style);
        this.chromatogramChart.setLayoutData(new GridData(1808));
        BaseChart baseChart = this.chromatogramChart.getBaseChart();
        baseChart.addCustomRangeSelectionHandler((ICustomSelectionHandler)new ChromatogramSelectionHandler(this));
        AnalysisSegmentPaintListener<IAnalysisSegment> listener = new AnalysisSegmentPaintListener<IAnalysisSegment>(AnalysisSegmentColorScheme.CHROMATOGRAM, new Supplier<Collection<IAnalysisSegment>>(){

            @Override
            public Collection<IAnalysisSegment> get() {
                if (ExtendedChromatogramUI.this.chromatogramSelection != null) {
                    return ExtendedChromatogramUI.this.chromatogramSelection.getChromatogram().getAnalysisSegments();
                }
                return Collections.emptyList();
            }
        }, always -> false);
        listener.setPaintArea(true);
        listener.setPaintLines(true);
        listener.setAlpha(50);
        baseChart.getPlotArea().addCustomPaintListener(listener);
        IChartSettings chartSettings = this.chromatogramChart.getChartSettings();
        chartSettings.setCreateMenu(true);
        chartSettings.setEnableRangeSelector(true);
        chartSettings.setRangeSelectorDefaultAxisX(1);
        chartSettings.setRangeSelectorDefaultAxisY(1);
        chartSettings.setShowRangeSelectorInitially(false);
        IChartMenuEntry chartMenuEntry = chartSettings.getChartMenuEntry(new ResetChartHandler().getName());
        chartSettings.removeMenuEntry(chartMenuEntry);
        chartSettings.addMenuEntry((IChartMenuEntry)new ChromatogramResetHandler(this));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new ScanSelectionHandler(this));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new PeakSelectionHandler(this));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new ScanSelectionArrowKeyHandler(this, 0x1000003));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new ScanSelectionArrowKeyHandler(this, 0x1000004));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new ChromatogramMoveArrowKeyHandler(this, 0x1000003));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new ChromatogramMoveArrowKeyHandler(this, 0x1000004));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new ChromatogramMoveArrowKeyHandler(this, 0x1000001));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new ChromatogramMoveArrowKeyHandler(this, 0x1000002));
        this.chromatogramChart.applySettings(chartSettings);
    }

    private void createHeatmap(Composite composite) {
        this.heatmapArea = new Composite(composite, 0);
        this.heatmapArea.setLayout((Layout)new FillLayout());
        this.heatmapUI = new HeatmapUI(this.heatmapArea);
    }

    private Button createToggleToolbarButton(Composite parent, String tooltip, final String image, final String toolbar) {
        final Button button = new Button(parent, 8);
        button.setToolTipText(tooltip);
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage(image, "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedChromatogramUI.this.toolbars.containsKey(toolbar)) {
                    boolean visible = PartSupport.toggleCompositeVisibility((Composite)((Composite)ExtendedChromatogramUI.this.toolbars.get(toolbar)));
                    if (visible) {
                        button.setImage(ApplicationImageFactory.getInstance().getImage(image, "16x16"));
                    } else {
                        button.setImage(ApplicationImageFactory.getInstance().getImage(image, "16x16"));
                    }
                }
            }
        });
        return button;
    }

    public TargetLabelEditAction createLabelsAction() {
        TargetLabelEditAction action = new TargetLabelEditAction(new TargetLabelEditAction.LabelChart(){

            @Override
            public void setChartMarkerVisible(boolean visible) {
                for (TargetReferenceLabelMarker marker : ExtendedChromatogramUI.this.scanLabelMarkerMap.values()) {
                    marker.setVisible(visible);
                }
                for (TargetReferenceLabelMarker marker : ExtendedChromatogramUI.this.peakLabelMarkerMap.values()) {
                    marker.setVisible(visible);
                }
            }

            @Override
            public void redraw() {
                this.getChart().redraw();
            }

            @Override
            public TargetDisplaySettings getTargetSettings() {
                return ExtendedChromatogramUI.this.getTargetSettings();
            }

            @Override
            public IChromatogramSelection<?, ?> getChromatogramSelection() {
                return ExtendedChromatogramUI.this.getChromatogramSelection();
            }

            public ChromatogramChart getChart() {
                return ExtendedChromatogramUI.this.getChromatogramChart();
            }
        }, this.preferenceStore);
        action.addChangeListener(() -> {
            TargetDisplaySettings targetSettings = this.getTargetSettings();
            if (targetSettings instanceof WorkspaceTargetDisplaySettings) {
                ((WorkspaceTargetDisplaySettings)targetSettings).flush();
            }
        });
        action.addChangeListener(this::updateChromatogram);
        return action;
    }

    private IAction createToggleToolbarAction(String name, final String tooltip, String image, final String toolbar) {
        return new Action(name, 2, image){
            {
                super($anonymous0, $anonymous1);
                this.setImageDescriptor(ApplicationImageFactory.getInstance().getImageDescriptor(string, "16x16"));
                this.setToolTipText(string2);
                this.updateText();
            }

            public void run() {
                if (ExtendedChromatogramUI.this.toolbars.containsKey(toolbar)) {
                    this.setChecked(PartSupport.toggleCompositeVisibility((Composite)((Composite)ExtendedChromatogramUI.this.toolbars.get(toolbar))));
                    this.updateText();
                }
            }

            private void updateText() {
                if (this.isChecked()) {
                    this.setToolTipText("Hide " + tooltip);
                } else {
                    this.setToolTipText("Show " + tooltip);
                }
            }
        };
    }

    private void createToggleChartSeriesLegendButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart series legend.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/tag.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedChromatogramUI.this.chromatogramChart.toggleSeriesLegendVisibility();
            }
        });
    }

    private void createToggleLegendMarkerButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart legend marker.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/chartLegendMarker.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedChromatogramUI.this.chromatogramChart.togglePositionLegendVisibility();
                ExtendedChromatogramUI.this.chromatogramChart.redraw();
            }
        });
    }

    private void createToggleRangeSelectorButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart range selector.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/chartRangeSelector.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedChromatogramUI.this.chromatogramChart.toggleRangeSelectorVisibility();
            }
        });
    }

    private void createResetButton(EditorToolBar editorToolBar) {
        editorToolBar.addAction((IAction)new Action("Reset", ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16")){
            {
                this.setToolTipText("Reset the chromatogram");
            }

            public void run() {
                ExtendedChromatogramUI.this.reset(true);
            }
        });
    }

    private void applySettings() {
        this.adjustAxisSettings();
        this.updateChromatogram();
    }

    private void reset(boolean resetRange) {
        this.updateChromatogram();
        if (resetRange && this.chromatogramSelection != null) {
            this.chromatogramSelection.reset(true);
        }
    }

    private void updateLabel() {
        if (this.chromatogramSelection != null) {
            this.labelChromatogramInfo.setText(ChromatogramDataSupport.getChromatogramLabelExtended(this.chromatogramSelection.getChromatogram()));
        } else {
            this.labelChromatogramInfo.setText("");
        }
    }

    private void deleteScanNumberSecondaryAxisX() {
        IChartSettings chartSettings = this.chromatogramChart.getChartSettings();
        List secondaryAxisSettings = chartSettings.getSecondaryAxisSettingsListX();
        ISecondaryAxisSettings secondaryAxisScanNumber = null;
        for (ISecondaryAxisSettings secondaryAxis : secondaryAxisSettings) {
            if (!secondaryAxis.getLabel().equals(LABEL_SCAN_NUMBER)) continue;
            secondaryAxisScanNumber = secondaryAxis;
            break;
        }
        if (secondaryAxisScanNumber != null) {
            secondaryAxisSettings.remove(secondaryAxisScanNumber);
        }
        this.chromatogramChart.applySettings(chartSettings);
    }

    private void adjustChromatogramSelectionRange() {
        if (this.chromatogramSelection != null) {
            this.chromatogramChart.setRange("X_AXIS", this.chromatogramSelection.getStartRetentionTime(), this.chromatogramSelection.getStopRetentionTime());
            this.chromatogramChart.setRange("Y_AXIS", this.chromatogramSelection.getStartAbundance(), this.chromatogramSelection.getStopAbundance());
        }
    }

    private void setSeparationColumnSelection() {
        ISeparationColumn separationColumn;
        if (this.chromatogramSelection != null && (separationColumn = this.chromatogramSelection.getChromatogram().getSeparationColumnIndices().getSeparationColumn()) != null) {
            String name = separationColumn.getName();
            int index = -1;
            String[] stringArray = this.comboViewerSeparationColumn.getCombo().getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                ++index;
                if (item.equals(name)) break;
                ++n2;
            }
            if (index >= 0) {
                this.comboViewerSeparationColumn.getCombo().select(index);
            }
        }
    }

    private void adjustAxisSettings() {
        IChromatogram chromatogram;
        this.chromatogramChart.modifyAxes(true);
        if (this.chromatogramSelection != null && (chromatogram = this.chromatogramSelection.getChromatogram()) != null) {
            IChartSettings chartSettings = this.chromatogramChart.getChartSettings();
            ISecondaryAxisSettings axisSettings = this.chartSupport.getSecondaryAxisSettingsX(this.titleScans, chartSettings);
            String title = this.preferenceStore.getString("titleXAxisScans");
            if (this.preferenceStore.getBoolean("showXAxisScans")) {
                if (axisSettings == null) {
                    try {
                        int scanDelay = chromatogram.getScanDelay();
                        int scanInterval = chromatogram.getScanInterval();
                        SecondaryAxisSettings secondaryAxisSettingsX = new SecondaryAxisSettings(title, (IAxisScaleConverter)new MillisecondsToScanNumberConverter(scanDelay, scanInterval));
                        secondaryAxisSettingsX.setTitleVisible(this.preferenceStore.getBoolean("showXAxisTitleScans"));
                        this.setScanAxisSettings((IAxisSettings)secondaryAxisSettingsX);
                        chartSettings.getSecondaryAxisSettingsListX().add(secondaryAxisSettingsX);
                    }
                    catch (Exception e) {
                        logger.warn((Object)e);
                    }
                } else {
                    axisSettings.setTitle(title);
                    this.setScanAxisSettings((IAxisSettings)axisSettings);
                }
            } else if (axisSettings != null) {
                axisSettings.setTitle(title);
                chartSettings.getSecondaryAxisSettingsListX().remove(axisSettings);
            }
            this.chromatogramChart.applySettings(chartSettings);
            this.titleScans = title;
        }
    }

    private void setScanAxisSettings(IAxisSettings axisSettings) {
        ChartSupport chartSupport = new ChartSupport(this.preferenceStore);
        IAxis.Position position = IAxis.Position.valueOf((String)this.preferenceStore.getString("positionXAxisScans"));
        Color color = Colors.getColor((String)this.preferenceStore.getString("colorXAxisScans"));
        LineStyle gridLineStyle = LineStyle.valueOf((String)this.preferenceStore.getString("gridlineStyleXAxisScans"));
        Color gridColor = Colors.getColor((String)this.preferenceStore.getString("gridlineColorXAxisScans"));
        chartSupport.setAxisSettings(axisSettings, position, "0", color, gridLineStyle, gridColor);
        String name = this.preferenceStore.getString("fontNameXAxisScans");
        int height = this.preferenceStore.getInt("fontSizeXAxisScans");
        int style = this.preferenceStore.getInt("fontStyleXAxisScans");
        Font titleFont = Fonts.getCachedFont((Device)this.chromatogramChart.getDisplay(), (String)name, (int)height, (int)style);
        axisSettings.setTitleFont(titleFont);
    }

    private void updateToolbar(Composite composite, IChromatogramSelection chromatogramSelection) {
        if (composite instanceof IChromatogramSelectionUpdateListener) {
            IChromatogramSelectionUpdateListener listener = (IChromatogramSelectionUpdateListener)composite;
            listener.update(chromatogramSelection);
        }
    }

    public void updateMethods() {
        this.methodSupportUI.applySettings();
    }

    public static void initializeChartDefaults(IPreferenceStore preferenceStore) {
        PreferenceInitializer.initializeChromatogramDefaults(preferenceStore);
        preferenceStore.setDefault(PREFERENCE_SHOW_TOOLBAR_TEXT, true);
        preferenceStore.setDefault(PREFERENCE_SHOW_LABELS_AT_TIC, false);
    }
}

