/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePagePeaksAxes;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.QuantPeakListUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExtendedQuantPeaksListUI
extends Composite {
    private static final String DESCRIPTION = "Quantitation Peaks";
    private Composite toolbarInfo;
    private Label labelInfo;
    private IQuantitationCompound quantitationCompound;
    private QuantPeakListUI quantPeakListUI;

    public ExtendedQuantPeaksListUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void update(IQuantitationCompound quantitationCompound) {
        this.quantitationCompound = quantitationCompound;
        this.updateInput();
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(composite);
        this.toolbarInfo = this.createToolbarInfo(composite);
        this.createTable(composite);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
        this.quantPeakListUI.setEditEnabled(false);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createResponseTableButton(composite);
        this.createButtonToggleEditModus(composite);
        this.createSettingsButton(composite);
    }

    private void createResponseTableButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Create Response Table");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/calculate.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedQuantPeaksListUI.this.quantitationCompound != null) {
                    if (ExtendedQuantPeaksListUI.this.quantitationCompound.getQuantitationPeaks().size() > 0) {
                        if (MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)ExtendedQuantPeaksListUI.DESCRIPTION, (String)"Would you like to create new concentration response and signal tables?")) {
                            ExtendedQuantPeaksListUI.this.quantitationCompound.calculateSignalTablesFromPeaks();
                        }
                    } else {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)ExtendedQuantPeaksListUI.DESCRIPTION, (String)"There are no quantitation peaks stored.");
                    }
                }
            }
        });
    }

    private Button createButtonToggleEditModus(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Enable/disable to edit the table.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean editEnabled = !ExtendedQuantPeaksListUI.this.quantPeakListUI.isEditEnabled();
                ExtendedQuantPeaksListUI.this.quantPeakListUI.setEditEnabled(editEnabled);
                button.setImage(ApplicationImageFactory.getInstance().getImage(editEnabled ? "org.eclipse.chemclipse.rcp.ui.icons/editEntryActive.gif" : "org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
                ExtendedQuantPeaksListUI.this.updateInput();
            }
        });
        return button;
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePagePeaksAxes()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedQuantPeaksListUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfo = new Label(composite, 0);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private void createTable(Composite parent) {
        this.quantPeakListUI = new QuantPeakListUI(parent, 68354);
        this.quantPeakListUI.getTable().setLayoutData((Object)new GridData(1808));
    }

    private void applySettings() {
        this.updateInput();
    }

    private void updateInput() {
        if (this.quantitationCompound != null) {
            String editInformation = this.quantPeakListUI.isEditEnabled() ? "(Edit is enabled)" : "(Edit is disabled)";
            this.labelInfo.setText("Quantitation Compound: " + this.quantitationCompound.getName() + " " + editInformation);
            this.quantPeakListUI.setInput(this.quantitationCompound.getQuantitationPeaks());
        } else {
            this.quantPeakListUI.clear();
        }
    }
}

