/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IMarkedSignal;
import org.eclipse.chemclipse.model.core.IMarkedSignals;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.updates.IUpdateListener;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIons;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.ChromatogramChart;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.ChartConfigSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.OverlayChartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.TraceValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageNamedTraces;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageOverlay;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.DisplayType;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramChartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.Derivative;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.DisplayModus;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.AxisConfig;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ChromatogramOverlayUIConfig;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ConfigurableUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.DataShiftControllerUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.traces.NamedTrace;
import org.eclipse.chemclipse.ux.extension.xxd.ui.traces.NamedTraces;
import org.eclipse.chemclipse.ux.extension.xxd.ui.traces.NamedTracesUI;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.support.MarkedWavelengths;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ISeriesModificationListener;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;

public class ExtendedChromatogramOverlayUI
implements ConfigurableUI<ChromatogramOverlayUIConfig> {
    private NamedTracesUI namedTracesUI;
    private DataShiftControllerUI dataShiftControllerUI;
    private ChromatogramChart chromatogramChart;
    private Composite toolbarMain;
    private Label labelStatus;
    private Combo comboOverlayType;
    private ComboViewer comboViewerDerivative;
    private final ChromatogramChartSupport chromatogramChartSupport = new ChromatogramChartSupport();
    private final OverlayChartSupport overlayChartSupport = new OverlayChartSupport();
    private final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private final Map<IChromatogramSelection, List<String>> chromatogramSelections = new LinkedHashMap<IChromatogramSelection, List<String>>();
    private final int style;
    private boolean lockZoom = false;

    public ExtendedChromatogramOverlayUI(Composite parent) {
        this(parent, 2048);
    }

    public ExtendedChromatogramOverlayUI(Composite parent, int style) {
        this.style = style;
        this.initialize(parent);
    }

    public void update(List<IChromatogramSelection> chromatogramSelections) {
        this.chromatogramSelections.clear();
        for (IChromatogramSelection selection : chromatogramSelections) {
            this.chromatogramSelections.put(selection, new ArrayList());
        }
        this.refreshUpdateOverlayChart();
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.toolbarMain = this.createToolbarMain(parent);
        this.namedTracesUI = this.createNamedTraces(parent);
        this.dataShiftControllerUI = this.createDataShiftControllerUI(parent);
        this.chromatogramChart = this.createOverlayChart(parent);
        PartSupport.setCompositeVisibility((Composite)this.namedTracesUI, (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.dataShiftControllerUI, (boolean)false);
        this.dataShiftControllerUI.setScrollableChart((ScrollableChart)this.chromatogramChart);
        this.modifyWidgetStatus();
        this.setDerivatives();
        parent.layout(true);
    }

    private void setDisplayModus(DisplayModus displayModus, String seriesId) {
        this.dataShiftControllerUI.setDisplayModus(displayModus, seriesId);
    }

    private Composite createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(8, false));
        this.labelStatus = this.createLabelStatus(composite);
        this.comboOverlayType = this.createOverlayTypeCombo(composite);
        this.comboViewerDerivative = this.createDerivativeComboViewer(composite);
        this.createToggleToolbarShiftButton(composite);
        this.createToggleChartLegendButton(composite);
        this.createResetButton(composite);
        this.createNewOverlayPartButton(composite);
        this.createSettingsButton(composite);
        return composite;
    }

    private NamedTracesUI createNamedTraces(Composite parent) {
        final NamedTracesUI namedTracesUI = new NamedTracesUI(parent, 0);
        namedTracesUI.setLayoutData(new GridData(768));
        namedTracesUI.setInput(new NamedTraces(this.preferenceStore.getString("chromatogramOverlayNamedTraces")));
        namedTracesUI.setUpdateListener(new IUpdateListener(){

            public void update() {
                NamedTraces namedTraces = namedTracesUI.getNamedTraces();
                if (namedTraces != null) {
                    ExtendedChromatogramOverlayUI.this.preferenceStore.putValue("chromatogramOverlayNamedTraces", namedTraces.save());
                    ExtendedChromatogramOverlayUI.this.chromatogramChart.deleteSeries();
                    ExtendedChromatogramOverlayUI.this.refreshUpdateOverlayChart();
                }
            }
        });
        return namedTracesUI;
    }

    private DataShiftControllerUI createDataShiftControllerUI(Composite parent) {
        DataShiftControllerUI dataShiftControllerUI = new DataShiftControllerUI(parent, 0);
        dataShiftControllerUI.setLayoutData(new GridData(768));
        return dataShiftControllerUI;
    }

    private Label createLabelStatus(Composite parent) {
        Label label = new Label(parent, 0);
        label.setToolTipText("Indicates whether the data has been modified or not.");
        label.setText("");
        label.setLayoutData((Object)new GridData(768));
        return label;
    }

    private Combo createOverlayTypeCombo(Composite parent) {
        final Combo combo = new Combo(parent, 8);
        combo.setToolTipText("Select the overlay type");
        GridData gridData = new GridData();
        gridData.minimumWidth = 150;
        combo.setLayoutData((Object)gridData);
        combo.setItems(this.overlayChartSupport.getOverlayTypes());
        combo.select(0);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = combo.getSelectionIndex();
                ExtendedChromatogramOverlayUI.this.comboOverlayType.select(index);
                ExtendedChromatogramOverlayUI.this.modifyWidgetStatus();
                ExtendedChromatogramOverlayUI.this.refreshUpdateOverlayChart();
            }
        });
        return combo;
    }

    private ComboViewer createDerivativeComboViewer(Composite parent) {
        ComboViewer comboViewer = new ComboViewer(parent, 8);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Derivative) {
                    Derivative derivative = (Derivative)((Object)element);
                    return derivative.getLabel();
                }
                return null;
            }
        });
        Combo combo = comboViewer.getCombo();
        combo.setToolTipText("Select the derivative type");
        GridData gridData = new GridData();
        gridData.minimumWidth = 150;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedChromatogramOverlayUI.this.refreshUpdateOverlayChart();
            }
        });
        return comboViewer;
    }

    private Button createToggleToolbarShiftButton(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the data shift toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/shiftDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedChromatogramOverlayUI.this.dataShiftControllerUI);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/shiftActive.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/shiftDefault.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private void createToggleChartLegendButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart legend");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/tag.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedChromatogramOverlayUI.this.chromatogramChart.toggleSeriesLegendVisibility();
            }
        });
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the Overlay");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedChromatogramOverlayUI.this.reset();
            }
        });
    }

    private void reset() {
        this.applyOverlaySettings();
    }

    private void createNewOverlayPartButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open a new Overlay");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/plus.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String bundle = Activator.getDefault().getBundle().getSymbolicName();
                String classPath = "org.eclipse.chemclipse.ux.extension.xxd.ui.parts.ChromatogramOverlayPart";
                String name = "Chromatogram Overlay";
                ExtendedChromatogramOverlayUI.this.createNewPart(bundle, classPath, name);
            }
        });
    }

    private void createNewPart(String bundle, String classPath, String name) {
        String partStackId = this.preferenceStore.getString("stackPositionOverlayChromatogramExtra");
        if (!partStackId.equals("")) {
            EModelService modelService = ModelSupportAddon.getModelService();
            MApplication application = ModelSupportAddon.getApplication();
            EPartService partService = ModelSupportAddon.getPartService();
            if (modelService != null && application != null && partService != null) {
                MPart part = MBasicFactory.INSTANCE.createPart();
                part.setLabel(name);
                part.setCloseable(true);
                part.setContributionURI("bundleclass://" + bundle + "/" + classPath);
                MPartStack partStack = PartSupport.getPartStack((String)partStackId, (EModelService)modelService, (MApplication)application);
                partStack.getChildren().add(part);
                PartSupport.showPart((MPart)part, (EPartService)partService);
            }
        }
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePageOverlay()));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)new PreferencePageNamedTraces()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedChromatogramOverlayUI.this.applyOverlaySettings();
                    }
                    catch (Exception e1) {
                        System.out.println(e1);
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private void modifyDataStatusLabel() {
        if (this.chromatogramChart.getBaseChart().isDataShifted()) {
            this.labelStatus.setText("The displayed data is shifted.");
            this.labelStatus.setBackground(Colors.YELLOW);
        } else {
            this.labelStatus.setText("");
            this.labelStatus.setBackground(null);
        }
    }

    private void modifyWidgetStatus() {
        Set<DisplayType> types = this.getOverlayType();
        this.comboOverlayType.setToolTipText(DisplayType.toDescription(types));
        if (this.preferenceStore.getBoolean("overlayAutofocusProfileSettings")) {
            if (this.isExtractedIonsModusEnabled() || this.isExtractedWavelengthsModusEnabled()) {
                PartSupport.setCompositeVisibility((Composite)this.namedTracesUI, (boolean)true);
            } else {
                PartSupport.setCompositeVisibility((Composite)this.namedTracesUI, (boolean)false);
            }
        }
        if (this.isExtractedIonsModusEnabled()) {
            this.namedTracesUI.setEnabled(true);
        } else if (this.isExtractedWavelengthsModusEnabled()) {
            this.namedTracesUI.setEnabled(false);
        } else {
            this.namedTracesUI.setEnabled(false);
        }
        this.dataShiftControllerUI.update();
    }

    private void setDerivatives() {
        Derivative[] derivatives = Derivative.values();
        this.comboViewerDerivative.setInput((Object)Derivative.values());
        if (derivatives.length > 0) {
            this.comboViewerDerivative.getCombo().select(0);
        }
    }

    private void applyOverlaySettings() {
        this.updateNamedTraces();
        this.chromatogramChartSupport.loadUserSettings();
        this.chromatogramChart.deleteSeries();
        this.refreshUpdateOverlayChart();
        this.modifyWidgetStatus();
        this.modifyDataStatusLabel();
    }

    private void updateNamedTraces() {
        this.namedTracesUI.setInput(new NamedTraces(this.preferenceStore.getString("chromatogramOverlayNamedTraces")));
    }

    private ChromatogramChart createOverlayChart(Composite parent) {
        ChromatogramChart chromatogramChart = new ChromatogramChart(parent, this.style);
        chromatogramChart.setLayoutData(new GridData(1808));
        IChartSettings chartSettings = chromatogramChart.getChartSettings();
        chartSettings.setCreateMenu(true);
        chartSettings.setEnableRangeSelector(true);
        chartSettings.setShowRangeSelectorInitially(false);
        chartSettings.setSupportDataShift(true);
        chartSettings.getRangeRestriction().setZeroY(false);
        chartSettings.setBufferSelection(this.preferenceStore.getBoolean("overlayBufferedSelection"));
        chromatogramChart.applySettings(chartSettings);
        BaseChart baseChart = chromatogramChart.getBaseChart();
        baseChart.addSeriesModificationListener(new ISeriesModificationListener(){

            public void handleSeriesModificationEvent() {
                ExtendedChromatogramOverlayUI.this.modifyDataStatusLabel();
            }
        });
        return chromatogramChart;
    }

    private void refreshUpdateOverlayChart() {
        if (this.chromatogramSelections.size() > 0) {
            IChartSettings chartSettings = this.chromatogramChart.getChartSettings();
            RangeRestriction rangeRestriction = chartSettings.getRangeRestriction();
            rangeRestriction.setExtendTypeX(RangeRestriction.ExtendType.ABSOLUTE);
            rangeRestriction.setExtendMaxX(0.0);
            rangeRestriction.setExtendTypeY(RangeRestriction.ExtendType.ABSOLUTE);
            rangeRestriction.setExtendMaxY(0.0);
            chartSettings.setBufferSelection(this.preferenceStore.getBoolean("overlayBufferedSelection"));
            this.chromatogramChart.applySettings(chartSettings);
            IAxisSet axisSet = this.chromatogramChart.getBaseChart().getAxisSet();
            Range xrange = axisSet.getXAxis(0).getRange();
            Range yrange = axisSet.getYAxis(0).getRange();
            HashSet<String> availableSeriesIds = new HashSet<String>();
            BaseChart baseChart = this.chromatogramChart.getBaseChart();
            ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
            int i = 0;
            for (Map.Entry<IChromatogramSelection, List<String>> entry : this.chromatogramSelections.entrySet()) {
                IChromatogramSelection chromatogramSelection = entry.getKey();
                List<String> selectionSeries = entry.getValue();
                IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                List referencedChromatograms = chromatogram.getReferencedChromatograms();
                String chromatogramName = String.valueOf(chromatogram.getName()) + "_EditorTab#" + (i + 1);
                Set<DisplayType> displayTypes = this.getOverlayType();
                Derivative derivative = this.getSelectedDerivative();
                if (derivative != null) {
                    for (DisplayType overlayType : displayTypes) {
                        Iterator<Number> color;
                        if (overlayType.equals((Object)DisplayType.SIC)) {
                            List<Number> ions = this.getSelectedTraces(true);
                            if (chromatogram instanceof IChromatogramMSD) {
                                for (Number number : ions) {
                                    int ion = number.intValue();
                                    String seriesId = String.valueOf(chromatogramName) + "_(" + (Object)((Object)overlayType) + "," + (Object)((Object)derivative) + "," + ion + ")";
                                    Color color2 = this.chromatogramChartSupport.getSeriesColor(seriesId, overlayType);
                                    availableSeriesIds.add(seriesId);
                                    selectionSeries.add(seriesId);
                                    if (baseChart.isSeriesContained(seriesId)) continue;
                                    MarkedIons markedIons = new MarkedIons(IMarkedIons.IonMarkMode.INCLUDE);
                                    markedIons.add(new int[]{ion});
                                    lineSeriesDataList.add(this.chromatogramChartSupport.getLineSeriesData(chromatogram, seriesId, overlayType, derivative, color2, (IMarkedSignals<? extends IMarkedSignal>)markedIons, false));
                                }
                            }
                            if (!this.preferenceStore.getBoolean("showReferencedChromatograms")) continue;
                            int j = 1;
                            for (IChromatogram referencedChromatogram : referencedChromatograms) {
                                if (!(referencedChromatogram instanceof IChromatogramMSD)) continue;
                                for (Number number : ions) {
                                    int ion = number.intValue();
                                    String referenceChromatogramName = String.valueOf(chromatogramName) + "_Reference#" + j++;
                                    String seriesId = String.valueOf(referenceChromatogramName) + "_(" + (Object)((Object)overlayType) + "," + (Object)((Object)derivative) + "," + ion + ")";
                                    Color color3 = this.chromatogramChartSupport.getSeriesColor(seriesId, overlayType);
                                    availableSeriesIds.add(seriesId);
                                    selectionSeries.add(seriesId);
                                    if (baseChart.isSeriesContained(seriesId)) continue;
                                    MarkedIons markedIons = new MarkedIons(IMarkedIons.IonMarkMode.INCLUDE);
                                    markedIons.add(new int[]{ion});
                                    lineSeriesDataList.add(this.chromatogramChartSupport.getLineSeriesData(chromatogram, seriesId, overlayType, derivative, color3, (IMarkedSignals<? extends IMarkedSignal>)markedIons, false));
                                }
                            }
                            continue;
                        }
                        if (overlayType.equals((Object)DisplayType.SWC)) {
                            List<Number> wavelengths = this.getSelectedTraces(false);
                            if (!(chromatogram instanceof IChromatogramWSD)) continue;
                            for (Number number : wavelengths) {
                                double wavelength = number.doubleValue();
                                String seriesId = String.valueOf(chromatogramName) + "_(" + (Object)((Object)overlayType) + "," + (Object)((Object)derivative) + "," + wavelength + ")";
                                availableSeriesIds.add(seriesId);
                                selectionSeries.add(seriesId);
                                color = this.chromatogramChartSupport.getSeriesColor(seriesId, overlayType);
                                MarkedWavelengths markedWavelengths = new MarkedWavelengths();
                                markedWavelengths.add(new double[]{wavelength});
                                if (baseChart.isSeriesContained(seriesId)) continue;
                                lineSeriesDataList.add(this.chromatogramChartSupport.getLineSeriesData(chromatogram, seriesId, overlayType, derivative, (Color)color, (IMarkedSignals<? extends IMarkedSignal>)markedWavelengths, false));
                            }
                            if (!this.preferenceStore.getBoolean("showReferencedChromatograms")) continue;
                            int j = 1;
                            for (IChromatogram referencedChromatogram : referencedChromatograms) {
                                if (!(referencedChromatogram instanceof IChromatogramWSD)) continue;
                                String referenceChromatogramName = String.valueOf(chromatogramName) + "_Reference#" + j++;
                                for (Number number : wavelengths) {
                                    double wavelength = number.doubleValue();
                                    String seriesId = String.valueOf(referenceChromatogramName) + "_(" + (Object)((Object)overlayType) + "," + (Object)((Object)derivative) + "," + wavelength + ")";
                                    availableSeriesIds.add(seriesId);
                                    selectionSeries.add(seriesId);
                                    Color color4 = this.chromatogramChartSupport.getSeriesColor(seriesId, overlayType);
                                    MarkedWavelengths markedWavelengths = new MarkedWavelengths();
                                    markedWavelengths.add(new double[]{wavelength});
                                    if (baseChart.isSeriesContained(seriesId)) continue;
                                    lineSeriesDataList.add(this.chromatogramChartSupport.getLineSeriesData(chromatogram, seriesId, overlayType, derivative, color4, (IMarkedSignals<? extends IMarkedSignal>)markedWavelengths, false));
                                }
                            }
                            continue;
                        }
                        if (overlayType.equals((Object)DisplayType.XWC)) {
                            if (!(chromatogram instanceof IChromatogramWSD)) continue;
                            Iterator referencedChromatogram = ((IChromatogramWSD)chromatogram).getWavelengths().iterator();
                            while (referencedChromatogram.hasNext()) {
                                double wavelength = (Double)referencedChromatogram.next();
                                String seriesId = String.valueOf(chromatogramName) + "_(" + (Object)((Object)overlayType) + "," + (Object)((Object)derivative) + "," + wavelength + ")";
                                availableSeriesIds.add(seriesId);
                                selectionSeries.add(seriesId);
                                Color color5 = this.chromatogramChartSupport.getSeriesColor(seriesId, overlayType);
                                MarkedWavelengths markedWavelengths = new MarkedWavelengths();
                                markedWavelengths.add(new double[]{wavelength});
                                if (baseChart.isSeriesContained(seriesId)) continue;
                                lineSeriesDataList.add(this.chromatogramChartSupport.getLineSeriesData(chromatogram, seriesId, overlayType, derivative, color5, (IMarkedSignals<? extends IMarkedSignal>)markedWavelengths, false));
                            }
                            if (!this.preferenceStore.getBoolean("showReferencedChromatograms")) continue;
                            int j = 1;
                            for (IChromatogram referencedChromatogram2 : referencedChromatograms) {
                                if (!(referencedChromatogram2 instanceof IChromatogramWSD)) continue;
                                String referenceChromatogramName = String.valueOf(chromatogramName) + "_Reference#" + j++;
                                color = ((IChromatogramWSD)referencedChromatogram2).getWavelengths().iterator();
                                while (color.hasNext()) {
                                    double wavelength = (Double)color.next();
                                    String seriesId = String.valueOf(referenceChromatogramName) + "_(" + (Object)((Object)overlayType) + "," + (Object)((Object)derivative) + "," + wavelength + ")";
                                    availableSeriesIds.add(seriesId);
                                    selectionSeries.add(seriesId);
                                    Color color6 = this.chromatogramChartSupport.getSeriesColor(seriesId, overlayType);
                                    MarkedWavelengths markedWavelengths = new MarkedWavelengths();
                                    markedWavelengths.add(new double[]{wavelength});
                                    if (baseChart.isSeriesContained(seriesId)) continue;
                                    lineSeriesDataList.add(this.chromatogramChartSupport.getLineSeriesData(chromatogram, seriesId, overlayType, derivative, color6, (IMarkedSignals<? extends IMarkedSignal>)markedWavelengths, false));
                                }
                            }
                            continue;
                        }
                        String seriesId = String.valueOf(chromatogramName) + "_(" + (Object)((Object)overlayType) + "," + (Object)((Object)derivative) + ")";
                        Color color7 = this.chromatogramChartSupport.getSeriesColor(chromatogramName, overlayType);
                        if (overlayType.equals((Object)DisplayType.BPC) || overlayType.equals((Object)DisplayType.XIC) || overlayType.equals((Object)DisplayType.TSC)) {
                            MarkedIons markedIons = new MarkedIons(IMarkedIons.IonMarkMode.INCLUDE);
                            List<Number> ions = this.getSelectedTraces(true);
                            markedIons.add(ions);
                            if (chromatogram instanceof IChromatogramMSD) {
                                availableSeriesIds.add(seriesId);
                                selectionSeries.add(seriesId);
                                if (!baseChart.isSeriesContained(seriesId)) {
                                    lineSeriesDataList.add(this.chromatogramChartSupport.getLineSeriesData(chromatogram, seriesId, overlayType, derivative, color7, (IMarkedSignals<? extends IMarkedSignal>)markedIons, false));
                                }
                            }
                            if (!this.preferenceStore.getBoolean("showReferencedChromatograms")) continue;
                            int j = 1;
                            for (IChromatogram referencedChromatogram : referencedChromatograms) {
                                if (!(referencedChromatogram instanceof IChromatogramMSD)) continue;
                                String referenceChromatogramName = String.valueOf(chromatogramName) + "_Reference#" + j++;
                                String referenceSeriesId = String.valueOf(referenceChromatogramName) + "_(" + (Object)((Object)overlayType) + "," + (Object)((Object)derivative) + ")";
                                availableSeriesIds.add(referenceSeriesId);
                                selectionSeries.add(seriesId);
                                if (baseChart.isSeriesContained(referenceSeriesId)) continue;
                                color7 = this.chromatogramChartSupport.getSeriesColor(referenceChromatogramName, overlayType);
                                lineSeriesDataList.add(this.chromatogramChartSupport.getLineSeriesData(referencedChromatogram, referenceSeriesId, overlayType, derivative, color7, (IMarkedSignals<? extends IMarkedSignal>)markedIons, false));
                            }
                            continue;
                        }
                        availableSeriesIds.add(seriesId);
                        selectionSeries.add(seriesId);
                        if (!baseChart.isSeriesContained(seriesId)) {
                            lineSeriesDataList.add(this.chromatogramChartSupport.getLineSeriesData(chromatogram, seriesId, overlayType, derivative, color7, null, false));
                        }
                        if (!this.preferenceStore.getBoolean("showReferencedChromatograms")) continue;
                        int j = 1;
                        for (IChromatogram referencedChromatogram : referencedChromatograms) {
                            if (referencedChromatogram == null) continue;
                            String referenceChromatogramName = String.valueOf(chromatogramName) + "_Reference#" + j++;
                            String referenceSeriesId = String.valueOf(referenceChromatogramName) + "_(" + (Object)((Object)overlayType) + "," + (Object)((Object)derivative) + ")";
                            availableSeriesIds.add(referenceSeriesId);
                            selectionSeries.add(referenceSeriesId);
                            if (baseChart.isSeriesContained(referenceSeriesId)) continue;
                            color7 = this.chromatogramChartSupport.getSeriesColor(referenceChromatogramName, overlayType);
                            lineSeriesDataList.add(this.chromatogramChartSupport.getLineSeriesData(referencedChromatogram, referenceSeriesId, overlayType, derivative, color7, null, false));
                        }
                    }
                }
                ++i;
            }
            String compressionType = this.preferenceStore.getString("overlayChartCompressionType");
            int compressionToLength = this.chromatogramChartSupport.getCompressionLength(compressionType, lineSeriesDataList.size());
            this.chromatogramChart.addSeriesData(lineSeriesDataList, compressionToLength);
            ISeries[] iSeriesArray = baseChart.getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries series = iSeriesArray[n2];
                String seriesId = series.getId();
                if (!availableSeriesIds.contains(seriesId)) {
                    baseChart.deleteSeries(seriesId);
                }
                ++n2;
            }
            this.dataShiftControllerUI.reset();
            this.modifyDataStatusLabel();
            this.chromatogramChart.adjustRange(true);
            if (this.lockZoom) {
                this.chromatogramChart.setRange("X_AXIS", xrange);
                this.chromatogramChart.setRange("Y_AXIS", yrange);
            }
        }
    }

    private Derivative getSelectedDerivative() {
        Object object = this.comboViewerDerivative.getStructuredSelection().getFirstElement();
        if (object instanceof Derivative) {
            return (Derivative)((Object)object);
        }
        return null;
    }

    private List<Number> getSelectedTraces(boolean isNominal) {
        TraceValidator traceValidator;
        IStatus status;
        ArrayList<Number> traceList = new ArrayList<Number>();
        NamedTrace namedTrace = this.namedTracesUI.getNamedTrace();
        if (namedTrace != null && (status = (traceValidator = new TraceValidator()).validate(namedTrace.getTraces())).isOK()) {
            List<Double> traces = traceValidator.getTraces();
            if (isNominal) {
                HashSet<Integer> tracesInt = new HashSet<Integer>();
                for (double trace : traces) {
                    tracesInt.add(Math.round((float)trace));
                }
                traceList.addAll(tracesInt);
            } else {
                traceList.addAll(traces);
            }
        }
        return traceList;
    }

    private Set<DisplayType> getOverlayType() {
        return DisplayType.toDisplayTypes(this.comboOverlayType.getText().trim());
    }

    private boolean isExtractedIonsModusEnabled() {
        Set<DisplayType> overlayType = this.getOverlayType();
        return overlayType.contains((Object)DisplayType.XIC) || overlayType.contains((Object)DisplayType.SIC) || overlayType.contains((Object)DisplayType.TSC);
    }

    private boolean isExtractedWavelengthsModusEnabled() {
        return this.getOverlayType().contains((Object)DisplayType.SWC);
    }

    @Override
    public ChromatogramOverlayUIConfig getConfig() {
        return new ChromatogramOverlayUIConfig(){
            ChartConfigSupport chartConfigSupport;
            {
                this.chartConfigSupport = new ChartConfigSupport((ScrollableChart)ExtendedChromatogramOverlayUI.this.chromatogramChart, EnumSet.of(AxisConfig.ChartAxis.PRIMARY_X, AxisConfig.ChartAxis.PRIMARY_Y, AxisConfig.ChartAxis.SECONDARY_Y));
            }

            @Override
            public void setToolbarVisible(boolean visible) {
                PartSupport.setCompositeVisibility((Composite)ExtendedChromatogramOverlayUI.this.toolbarMain, (boolean)visible);
            }

            @Override
            public boolean isToolbarVisible() {
                return ExtendedChromatogramOverlayUI.this.toolbarMain.isVisible();
            }

            @Override
            public void setAxisLabelVisible(AxisConfig.ChartAxis axis, boolean visible) {
                this.chartConfigSupport.setAxisLabelVisible(axis, visible);
            }

            @Override
            public void setAxisVisible(AxisConfig.ChartAxis axis, boolean visible) {
                this.chartConfigSupport.setAxisVisible(axis, visible);
            }

            @Override
            public boolean hasAxis(AxisConfig.ChartAxis axis) {
                return this.chartConfigSupport.hasAxis(axis);
            }

            @Override
            public void setDisplayModus(DisplayModus modus, IChromatogramSelection<?, ?> selection) {
                List list = (List)ExtendedChromatogramOverlayUI.this.chromatogramSelections.get(selection);
                if (list != null) {
                    for (String id : list) {
                        if (modus == DisplayModus.MIRRORED) {
                            ExtendedChromatogramOverlayUI.this.setDisplayModus(DisplayModus.MIRRORED, id);
                            continue;
                        }
                        ExtendedChromatogramOverlayUI.this.setDisplayModus(DisplayModus.NORMAL, id);
                    }
                }
            }
        };
    }

    public void setZoomLocked(boolean lockZoom) {
        this.lockZoom = lockZoom;
    }
}

