/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import java.util.function.Function;
import org.eclipse.chemclipse.model.core.Classifiable;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramPeak;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.chemclipse.support.ui.swt.columns.ColumnDefinition;
import org.eclipse.chemclipse.support.ui.swt.columns.ColumnDefinitionProvider;
import org.eclipse.chemclipse.support.ui.swt.columns.SimpleColumnDefinition;
import org.eclipse.chemclipse.support.ui.swt.dialogs.ContentProposalInputDialog;
import org.eclipse.chemclipse.support.ui.swt.edit.ListEdit;
import org.eclipse.chemclipse.support.ui.swt.edit.ListEditModel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ClassifierCellEditor
extends DialogCellEditor {
    public ClassifierCellEditor(TableViewer tableViewer) {
        super((Composite)tableViewer.getTable());
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        System.out.println("ClassifierCellEditor.openDialogBox()");
        Object value = this.getValue();
        if (value instanceof Classifiable) {
            Classifiable classifiable = (Classifiable)value;
            ClassifierDialog dialog = new ClassifierDialog(cellEditorWindow.getShell(), classifiable);
            if (dialog.open() == 0) {
                return new LinkedHashSet(dialog.listEdit.getValue());
            }
        }
        return value;
    }

    protected void updateContents(Object value) {
        Label label;
        if (value instanceof Classifiable && (label = this.getDefaultLabel()) != null && !label.isDisposed()) {
            Collection classifier = ((Classifiable)value).getClassifier();
            if (classifier.isEmpty()) {
                label.setText("");
            } else if (classifier.size() == 1) {
                label.setText((String)classifier.iterator().next());
            } else {
                label.setText(String.valueOf(classifier.size()) + " Classifier");
            }
            return;
        }
        super.updateContents(value);
    }

    private static final class ClassifierDialog
    extends Dialog
    implements ColumnDefinitionProvider,
    IContentProposalProvider {
        private ListEdit<String> listEdit;
        private final Classifiable classifiable;
        private IContentProposal[] proposals;

        protected ClassifierDialog(Shell parentShell, Classifiable classifiable) {
            super(parentShell);
            this.classifiable = classifiable;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            this.listEdit = new ListEdit(container, (ColumnDefinitionProvider)this, (ListEditModel)new ListEditModel<String>(){

                public Collection<? extends String> list() {
                    return classifiable.getClassifier();
                }

                public boolean canCreate() {
                    return true;
                }

                public boolean canDelete(String item) {
                    return true;
                }

                public String create() {
                    ContentProposalInputDialog dialog = new ContentProposalInputDialog(this.getShell(), "Add Classification", "Enter new Classification", "", null, (IContentProposalProvider)this);
                    if (dialog.open() == 0) {
                        return dialog.getValue();
                    }
                    return null;
                }
            });
            ControlBuilder.fill((Control)this.listEdit.getControl());
            return container;
        }

        protected Point getInitialSize() {
            return new Point(600, 400);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Edit Classification");
        }

        public Collection<? extends ColumnDefinition<?, ?>> getColumnDefinitions() {
            return Collections.singleton(new SimpleColumnDefinition("Classification", 400, Function.identity()));
        }

        public IContentProposal[] getProposals(String contents, int position) {
            if (this.proposals == null) {
                if (this.classifiable instanceof IChromatogramPeak) {
                    TreeSet set = new TreeSet();
                    IChromatogram chromatogram = ((IChromatogramPeak)this.classifiable).getChromatogram();
                    for (IPeak peak : chromatogram.getPeaks()) {
                        set.addAll(peak.getClassifier());
                    }
                    String[] array = set.toArray(new String[0]);
                    this.proposals = new IContentProposal[array.length];
                    int i = 0;
                    while (i < this.proposals.length) {
                        this.proposals[i] = new ContentProposal(array[i]);
                        ++i;
                    }
                } else {
                    this.proposals = new IContentProposal[0];
                }
            }
            return this.proposals;
        }
    }
}

