/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IRegularMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.SignalType;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChartSupport;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swtchart.extensions.core.IChartSettings;

public class ScanDataSupport {
    public static final String[] DATA_TYPES_DEFAULT = new String[]{DataType.AUTO_DETECT.toString()};
    public static final String[] DATA_TYPES_MSD = new String[]{DataType.AUTO_DETECT.toString(), DataType.MSD_NOMINAL.toString(), DataType.MSD_TANDEM.toString(), DataType.MSD_HIGHRES.toString()};
    public static final String[] DATA_TYPES_CSD = new String[]{DataType.AUTO_DETECT.toString(), DataType.CSD.toString()};
    public static final String[] DATA_TYPES_WSD = new String[]{DataType.AUTO_DETECT.toString(), DataType.WSD.toString()};
    public static final String[] SIGNAL_TYPES_DEFAULT = new String[]{SignalType.AUTO_DETECT.toString()};
    public static final String[] SIGNAL_TYPES_MSD = new String[]{SignalType.AUTO_DETECT.toString(), SignalType.CENTROID.toString(), SignalType.PROFILE.toString()};
    public static final String[] SIGNAL_TYPES_CSD = new String[]{SignalType.AUTO_DETECT.toString(), SignalType.CENTROID.toString()};
    public static final String[] SIGNAL_TYPES_WSD = new String[]{SignalType.AUTO_DETECT.toString(), SignalType.CENTROID.toString(), SignalType.PROFILE.toString()};
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0##");
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();

    public String extractTracesText(IScanMSD scanMSD, int maxCopyTraces) {
        List<Integer> traces = this.extractTracesList(scanMSD, maxCopyTraces);
        Iterator<Integer> iterator = traces.iterator();
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    public List<Integer> extractTracesList(IScanMSD scanMSD, int maxCopyTraces) {
        ArrayList<Integer> traces = new ArrayList<Integer>();
        if (scanMSD != null) {
            IScanMSD massSpectrum = scanMSD.getOptimizedMassSpectrum() != null ? scanMSD.getOptimizedMassSpectrum() : scanMSD;
            ArrayList ions = new ArrayList(massSpectrum.getIons());
            Collections.sort(ions, (i1, i2) -> Float.compare(i2.getAbundance(), i1.getAbundance()));
            for (IIon ion : ions) {
                int trace = AbstractIon.getIon((double)ion.getIon());
                if (!traces.contains(trace)) {
                    traces.add(trace);
                }
                if (traces.size() >= maxCopyTraces) break;
            }
        }
        Collections.sort(traces);
        return traces;
    }

    public String getRetentionTime(IScan scan) {
        if (scan != null) {
            return this.decimalFormat.format((double)scan.getRetentionTime() / 60000.0);
        }
        return "";
    }

    public String getScanLabel(IScan scan) {
        StringBuilder builder = new StringBuilder();
        if (scan != null) {
            IScanMSD scanMSD;
            IScanMSD optimizedMassSpectrum;
            if (scan instanceof IPeakMassSpectrum) {
                builder.append("Peak Scan");
                builder.append(" | ");
            } else {
                builder.append("Scan: ");
                builder.append(scan.getScanNumber());
                builder.append(" | ");
            }
            builder.append("RT: ");
            builder.append(this.decimalFormat.format((double)scan.getRetentionTime() / 60000.0));
            builder.append(" | ");
            builder.append("RI: ");
            if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
                builder.append(Integer.toString((int)scan.getRetentionIndex()));
            } else {
                builder.append(this.decimalFormat.format(scan.getRetentionIndex()));
            }
            if (scan instanceof IRegularMassSpectrum) {
                IRegularMassSpectrum massSpectrum = (IRegularMassSpectrum)scan;
                builder.append(" | ");
                builder.append("Detector: MS");
                builder.append(massSpectrum.getMassSpectrometer());
                builder.append(" | ");
                builder.append("Type: ");
                builder.append(massSpectrum.getMassSpectrumTypeDescription());
            }
            builder.append(" | ");
            builder.append("Signal: ");
            builder.append((int)scan.getTotalSignal());
            if (scan instanceof IScanMSD && (optimizedMassSpectrum = (scanMSD = (IScanMSD)scan).getOptimizedMassSpectrum()) != null) {
                builder.append(" | ");
                builder.append("optimized");
            }
        } else {
            builder.append("No scan has been selected yet.");
        }
        return builder.toString();
    }

    public String getMassSpectrumLabel(IScanMSD scanMSD, String prefix, String title, String postfix) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        builder.append(" ");
        builder.append(title);
        builder.append(" = ");
        if (scanMSD != null) {
            if (scanMSD instanceof IRegularLibraryMassSpectrum) {
                IRegularLibraryMassSpectrum libraryMassSpectrum = (IRegularLibraryMassSpectrum)scanMSD;
                ILibraryInformation libraryInformation = libraryMassSpectrum.getLibraryInformation();
                builder.append("NAME: ");
                builder.append(libraryInformation.getName());
                builder.append(" | ");
                builder.append("CAS: ");
                builder.append(libraryInformation.getCasNumber());
                builder.append(" | ");
            }
            builder.append("RT: ");
            builder.append(this.decimalFormat.format((double)scanMSD.getRetentionTime() / 60000.0));
            builder.append(" | ");
            builder.append("RI: ");
            if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
                builder.append(Integer.toString((int)scanMSD.getRetentionIndex()));
            } else {
                builder.append(this.decimalFormat.format(scanMSD.getRetentionIndex()));
            }
            IScanMSD optimizedMassSpectrum = scanMSD.getOptimizedMassSpectrum();
            if (optimizedMassSpectrum != null) {
                builder.append(" | ");
                builder.append("optimized");
            }
            if (!"".equals(postfix)) {
                builder.append(" | ");
                builder.append(postfix);
                builder.append("*");
            }
        } else {
            builder.append("No mass spectrum has been selected yet.");
        }
        return builder.toString();
    }

    public boolean containsOptimizedScan(IScan scan) {
        IScanMSD scanMSD;
        IScanMSD optimizedMassSpectrum;
        boolean containsOptimizedScan = false;
        if (scan instanceof IScanMSD && (optimizedMassSpectrum = (scanMSD = (IScanMSD)scan).getOptimizedMassSpectrum()) != null) {
            containsOptimizedScan = true;
        }
        return containsOptimizedScan;
    }

    public void setDataTypeMSD(IChartSettings chartSettings) {
        String titleX = this.preferenceStore.getString("titleXAxisMZ");
        String titleY = this.preferenceStore.getString("titleYAxisIntensity");
        String titleY1 = this.preferenceStore.getString("titleYAxisRelativeIntensity");
        ChartSupport.setPrimaryAxisSet(chartSettings, titleX, true, titleY);
        ChartSupport.clearSecondaryAxes(chartSettings);
        ChartSupport.addSecondaryAxisY(chartSettings, titleY1);
    }

    public void setDataTypeCSD(IChartSettings chartSettings) {
        String titleX = this.preferenceStore.getString("titleXAxisMilliseconds");
        String titleX1 = this.preferenceStore.getString("titleXAxisMinutes");
        String titleY = this.preferenceStore.getString("titleYAxisIntensity");
        String titleY1 = this.preferenceStore.getString("titleYAxisRelativeIntensity");
        ChartSupport.setPrimaryAxisSet(chartSettings, titleX, false, titleY);
        ChartSupport.clearSecondaryAxes(chartSettings);
        ChartSupport.addSecondaryAxisX(chartSettings, titleX1);
        ChartSupport.addSecondaryAxisY(chartSettings, titleY1);
    }

    public void setDataTypeWSD(IChartSettings chartSettings) {
        String titleX = this.preferenceStore.getString("titleXAxisWavelength");
        String titleY = this.preferenceStore.getString("titleYAxisIntensity");
        String titleY1 = this.preferenceStore.getString("titleYAxisRelativeIntensity");
        ChartSupport.setPrimaryAxisSet(chartSettings, titleX, true, titleY);
        ChartSupport.clearSecondaryAxes(chartSettings);
        ChartSupport.addSecondaryAxisY(chartSettings, titleY1);
    }
}

