/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.parts;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.AbstractDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ExtendedPeakDetectorUI;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;

public class PeakDetectorPart
extends AbstractDataUpdateSupport
implements IDataUpdateSupport {
    private ExtendedPeakDetectorUI extendedPeakDetectorUI;

    @Inject
    public PeakDetectorPart(Composite parent, MPart part) {
        super(part);
        this.extendedPeakDetectorUI = new ExtendedPeakDetectorUI(parent);
    }

    @Focus
    public void setFocus() {
        this.updateObjects(this.getObjects(), this.getTopic());
    }

    @Override
    public void registerEvents() {
        this.registerEvent("chromatogram/msd/update/chromatogramselection", "ChromatogramSelection");
        this.registerEvent("chromatogram/csd/update/chromatogramselection", "ChromatogramSelection");
        this.registerEvent("chromatogram/wsd/update/chromatogramselection", "ChromatogramSelection");
        this.registerEvent("chromatogram/xxd/unload/chromatogramselection", "org.eclipse.e4.data");
    }

    @Override
    public void updateObjects(List<Object> objects, String topic) {
        if (objects.size() == 1) {
            if (this.isUnloadEvent(topic)) {
                this.extendedPeakDetectorUI.update(null);
            } else {
                Object object = objects.get(0);
                if (object instanceof IChromatogramSelection) {
                    IChromatogramSelection chromatogramSelection = (IChromatogramSelection)object;
                    this.extendedPeakDetectorUI.update(chromatogramSelection);
                }
            }
        }
    }

    private boolean isUnloadEvent(String topic) {
        return topic.equals("peak/xxd/unload/selection");
    }
}

