/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.part.support;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.eclipse.chemclipse.converter.methods.MethodConverter;
import org.eclipse.chemclipse.converter.quantitation.QuantDBConverter;
import org.eclipse.chemclipse.converter.sequence.SequenceConverter;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.model.core.IMeasurement;
import org.eclipse.chemclipse.model.core.IMeasurementInfo;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.nmr.converter.core.ScanConverterNMR;
import org.eclipse.chemclipse.pcr.converter.core.PlateConverterPCR;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.rcp.app.ui.handlers.OpenSnippetHandler;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.ux.extension.ui.editors.EditorDescriptor;
import org.eclipse.chemclipse.ux.extension.ui.provider.AbstractSupplierFileEditorSupport;
import org.eclipse.chemclipse.ux.extension.ui.provider.ISupplierEditorSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.wsd.converter.chromatogram.ChromatogramConverterWSD;
import org.eclipse.chemclipse.xir.converter.core.ScanConverterXIR;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;

public class SupplierEditorSupport
extends AbstractSupplierFileEditorSupport
implements ISupplierEditorSupport {
    private static final Object NO_EXECUTE_METHOD = new Object();
    private String type = "";
    private String elementId = "";
    private String contributionURI = "";
    private String iconURI = "";
    private String tooltip = "";
    private String topicUpdateRawfile = "";
    private String topicUpdateOverview = "";
    private String snippetId;
    private final Supplier<IEclipseContext> contextSupplier;
    private final DataType dataType;

    @Deprecated
    public SupplierEditorSupport(DataType dataType) {
        this(dataType, ModelSupportAddon::getEclipseContext);
    }

    public SupplierEditorSupport(DataType dataType, Supplier<IEclipseContext> contextSupplier) {
        super(SupplierEditorSupport.getSupplier(dataType));
        this.dataType = dataType;
        this.contextSupplier = contextSupplier;
        this.initialize(dataType);
    }

    private static List<ISupplier> getSupplier(DataType dataType) {
        List<Object> supplier = new ArrayList<ISupplier>();
        switch (dataType) {
            case MSD_NOMINAL: 
            case MSD_TANDEM: 
            case MSD_HIGHRES: 
            case MSD: {
                supplier = ChromatogramConverterMSD.getInstance().getChromatogramConverterSupport().getSupplier();
                break;
            }
            case CSD: {
                supplier = ChromatogramConverterCSD.getInstance().getChromatogramConverterSupport().getSupplier();
                break;
            }
            case WSD: {
                supplier = ChromatogramConverterWSD.getInstance().getChromatogramConverterSupport().getSupplier();
                break;
            }
            case XIR: {
                supplier = ScanConverterXIR.getScanConverterSupport().getSupplier();
                break;
            }
            case NMR: {
                supplier = ScanConverterNMR.getScanConverterSupport().getSupplier();
                break;
            }
            case PCR: {
                supplier = PlateConverterPCR.getScanConverterSupport().getSupplier();
                break;
            }
            case SEQ: {
                supplier = SequenceConverter.getSequenceConverterSupport().getSupplier();
                break;
            }
            case MTH: {
                supplier = MethodConverter.getMethodConverterSupport().getSupplier();
                break;
            }
            case QDB: {
                supplier = QuantDBConverter.getQuantDBConverterSupport().getSupplier();
            }
        }
        return supplier;
    }

    private void initialize(DataType dataType) {
        this.type = "";
        this.elementId = "";
        this.contributionURI = "";
        this.iconURI = "";
        this.tooltip = "";
        this.topicUpdateRawfile = "";
        this.topicUpdateOverview = "";
        this.snippetId = "";
        switch (dataType) {
            case MSD_NOMINAL: 
            case MSD_TANDEM: 
            case MSD_HIGHRES: 
            case MSD: {
                this.type = "MSD";
                this.elementId = "org.eclipse.chemclipse.ux.extension.xxd.ui.part.chromatogramEditorMSD";
                this.contributionURI = "bundleclass://org.eclipse.chemclipse.ux.extension.xxd.ui/org.eclipse.chemclipse.ux.extension.xxd.ui.editors.ChromatogramEditorMSD";
                this.iconURI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/chromatogram.gif";
                this.tooltip = "Chromatogram Editor";
                this.topicUpdateRawfile = "chromatogram/msd/update/rawfile";
                this.topicUpdateOverview = "chromatogram/msd/update/overview";
                break;
            }
            case CSD: {
                this.type = "CSD";
                this.elementId = "org.eclipse.chemclipse.ux.extension.xxd.ui.part.chromatogramEditorCSD";
                this.contributionURI = "bundleclass://org.eclipse.chemclipse.ux.extension.xxd.ui/org.eclipse.chemclipse.ux.extension.xxd.ui.editors.ChromatogramEditorCSD";
                this.iconURI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/chromatogram.gif";
                this.tooltip = "Chromatogram Editor";
                this.topicUpdateRawfile = "chromatogram/csd/update/rawfile";
                this.topicUpdateOverview = "chromatogram/csd/update/overview";
                break;
            }
            case WSD: {
                this.type = "WSD";
                this.elementId = "org.eclipse.chemclipse.ux.extension.xxd.ui.part.chromatogramEditorWSD";
                this.contributionURI = "bundleclass://org.eclipse.chemclipse.ux.extension.xxd.ui/org.eclipse.chemclipse.ux.extension.xxd.ui.editors.ChromatogramEditorWSD";
                this.iconURI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/chromatogram.gif";
                this.tooltip = "Chromatogram Editor";
                this.topicUpdateRawfile = "chromatogram/wsd/update/rawfile";
                this.topicUpdateOverview = "chromatogram/wsd/update/overview";
                break;
            }
            case XIR: {
                this.type = "XIR";
                this.elementId = "org.eclipse.chemclipse.ux.extension.xxd.ui.part.scanEditorXIR";
                this.contributionURI = "bundleclass://org.eclipse.chemclipse.ux.extension.xxd.ui/org.eclipse.chemclipse.ux.extension.xxd.ui.editors.ScanEditorXIR";
                this.iconURI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/scan-xir.gif";
                this.tooltip = "FTIR/NIR/MIR Editor";
                this.topicUpdateRawfile = "scan/xir/update/rawfile";
                this.topicUpdateOverview = "scan/xir/update/overview";
                break;
            }
            case NMR: {
                this.type = "NMR";
                this.elementId = "org.eclipse.chemclipse.ux.extension.xxd.ui.part.scanEditorNMR";
                this.contributionURI = "bundleclass://org.eclipse.chemclipse.ux.extension.xxd.ui/org.eclipse.chemclipse.ux.extension.xxd.ui.editors.ScanEditorNMR";
                this.iconURI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/scan-nmr.gif";
                this.tooltip = "NMR Editor";
                this.topicUpdateRawfile = "scan/nmr/update/rawfile";
                this.topicUpdateOverview = "scan/nmr/update/overview";
                break;
            }
            case PCR: {
                this.type = "PCR";
                this.elementId = "org.eclipse.chemclipse.ux.extension.xxd.ui.part.plateEditorPCR";
                this.contributionURI = "bundleclass://org.eclipse.chemclipse.ux.extension.xxd.ui/org.eclipse.chemclipse.ux.extension.xxd.ui.editors.PlateEditorPCR";
                this.iconURI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/plate-pcr.gif";
                this.tooltip = "PCR Editor";
                this.topicUpdateRawfile = "plate/pcr/update/rawfile";
                this.topicUpdateOverview = "plate/pcr/update/overview";
                break;
            }
            case SEQ: {
                this.type = "SEQ";
                this.elementId = "org.eclipse.chemclipse.ux.extension.xxd.ui.part.sequenceEditor";
                this.contributionURI = "bundleclass://org.eclipse.chemclipse.ux.extension.xxd.ui/org.eclipse.chemclipse.ux.extension.xxd.ui.editors.SequenceEditor";
                this.iconURI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/sequenceListDefault.gif";
                this.tooltip = "Sequence Editor";
                this.topicUpdateRawfile = "sequence/update/rawfile";
                this.topicUpdateOverview = "sequence/update/overview";
                break;
            }
            case MTH: {
                this.type = "MTH";
                this.snippetId = "org.eclipse.chemclipse.ux.extension.xxd.ui.part.processMethodEditor";
                this.topicUpdateRawfile = "method/update/rawfile";
                this.topicUpdateOverview = "method/update/overview";
                break;
            }
            case QDB: {
                this.type = "QDB";
                this.elementId = "org.eclipse.chemclipse.ux.extension.xxd.ui.part.quantitationDatabaseEditor";
                this.contributionURI = "bundleclass://org.eclipse.chemclipse.ux.extension.xxd.ui/org.eclipse.chemclipse.ux.extension.xxd.ui.editors.QuantitationDatabaseEditor";
                this.iconURI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/database.gif";
                this.tooltip = "Quantitation Editor";
                this.topicUpdateRawfile = "quantitation/database/update/rawfile";
                this.topicUpdateOverview = "quantitation/database/update/overview";
                break;
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public boolean openEditor(final File file, boolean batch) {
        if (this.isSupplierFile(file) || this.isSupplierFileDirectory(file)) {
            if (!this.snippetId.isEmpty()) {
                OpenSnippetHandler.openSnippet((String)this.snippetId, (IEclipseContext)this.contextSupplier.get(), (BiFunction)new BiFunction<IEclipseContext, MPart, Runnable>(){

                    @Override
                    public Runnable apply(IEclipseContext context, MPart part) {
                        part.setLabel(file.getName());
                        context.set(File.class, (Object)file);
                        return null;
                    }
                });
            } else {
                this.openEditor(file, null, this.elementId, this.contributionURI, this.iconURI, this.tooltip, batch);
            }
            return true;
        }
        return false;
    }

    public boolean openEditor(File file, ISupplier supplier) {
        IEclipseContext eclipseContext = this.contextSupplier.get();
        IEclipseContext parameterContext = EclipseContextFactory.create();
        try {
            Object[] executables;
            parameterContext.set(File.class, (Object)file);
            parameterContext.set(ISupplier.class, (Object)supplier);
            Object[] objectArray = executables = new Object[]{Adapters.adapt((Object)supplier, EditorDescriptor.class), supplier};
            int n = executables.length;
            int n2 = 0;
            while (n2 < n) {
                Object invoke;
                Object executable = objectArray[n2];
                if (executable != null && NO_EXECUTE_METHOD != (invoke = ContextInjectionFactory.invoke((Object)executable, Execute.class, (IEclipseContext)eclipseContext, (IEclipseContext)parameterContext, (Object)NO_EXECUTE_METHOD))) {
                    if (invoke instanceof Boolean) {
                        boolean bl = (Boolean)invoke;
                        return bl;
                    }
                    return true;
                }
                ++n2;
            }
        }
        finally {
            parameterContext.dispose();
        }
        return this.openEditor(file, false);
    }

    public void openEditor(final IMeasurement measurement) {
        if (this.snippetId.isEmpty()) {
            this.openEditor(null, measurement, this.elementId, this.contributionURI, this.iconURI, this.tooltip);
        } else {
            OpenSnippetHandler.openSnippet((String)this.snippetId, (IEclipseContext)this.contextSupplier.get(), (BiFunction)new BiFunction<IEclipseContext, MPart, Runnable>(){

                @Override
                public Runnable apply(IEclipseContext context, MPart part) {
                    context.set(IMeasurement.class, (Object)measurement);
                    context.set(DataType.class, (Object)SupplierEditorSupport.this.dataType);
                    File file = measurement.getFile();
                    if (file != null) {
                        context.set(File.class, (Object)file);
                    }
                    return null;
                }
            });
        }
    }

    public void openOverview(File file) {
        if (this.isSupplierFile(file) || this.isSupplierFileDirectory(file)) {
            IEventBroker eventBroker = Activator.getDefault().getEventBroker();
            eventBroker.send(this.topicUpdateRawfile, (Object)file);
        }
    }

    public void openOverview(IMeasurementInfo measurementInfo) {
        IEventBroker eventBroker = Activator.getDefault().getEventBroker();
        eventBroker.send(this.topicUpdateOverview, (Object)measurementInfo);
    }
}

