/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.methods;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.NodeProcessorPreferences;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;
import org.eclipse.chemclipse.ux.extension.xxd.ui.methods.SettingsPreferencesEditPage;
import org.eclipse.chemclipse.ux.extension.xxd.ui.methods.SettingsPreferencesPage;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class SettingsWizard
extends Wizard {
    public static final int DEFAULT_WIDTH = 500;
    public static final int DEFAULT_HEIGHT = 600;
    private static IEclipsePreferences preferences;

    private SettingsWizard(String title) {
        this.setWindowTitle(title);
        this.setNeedsProgressMonitor(false);
    }

    public boolean performFinish() {
        return true;
    }

    public static <T> boolean openEditPreferencesWizard(Shell shell, ProcessorPreferences<T> preferences) throws IOException {
        IProcessSupplier processorSupplier = preferences.getSupplier();
        SettingsWizard wizard = new SettingsWizard("Edit Processor Options");
        SettingsPreferencesPage<T> page = new SettingsPreferencesPage<T>(preferences);
        page.setTitle("Select options to use for " + processorSupplier.getName());
        page.setMessage(processorSupplier.getDescription());
        wizard.addPage((IWizardPage)page);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
        wizardDialog.setMinimumPageSize(500, 600);
        if (wizardDialog.open() == 0) {
            preferences.setAskForSettings(!page.getIsDontAskAgainEdited());
            boolean useSystem = page.getIsUseSystemDefaultsEdited();
            if (useSystem) {
                preferences.setUseSystemDefaults(true);
            } else {
                preferences.setUseSystemDefaults(false);
                preferences.setUserSettings(page.getSettingsEdited());
            }
            return true;
        }
        return false;
    }

    public static void openManagePreferencesWizard(Shell shell, Supplier<Collection<ProcessorPreferences<?>>> preferenceSupplier) {
        SettingsWizard wizard = new SettingsWizard("Manage Processor Options");
        SettingsPreferencesEditPage page = new SettingsPreferencesEditPage(preferenceSupplier);
        page.setTitle("Manage Preferences");
        page.setDescription("Below you find all currently stored processor Options, select one to manage or remove the stored state");
        wizard.addPage((IWizardPage)page);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard){

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
            }

            protected void buttonPressed(int buttonId) {
                this.cancelPressed();
            }

            public void updateButtons() {
            }
        };
        wizardDialog.setMinimumPageSize(500, 600);
        wizardDialog.open();
    }

    public static <T> ProcessorPreferences<T> getSettings(Shell shell, ProcessorPreferences<T> preferences) throws IOException {
        IProcessSupplier processSupplier = preferences.getSupplier();
        Class settingsClass = processSupplier.getSettingsClass();
        if (settingsClass == null) {
            return preferences;
        }
        if (preferences.getDialogBehaviour() == ProcessorPreferences.DialogBehavior.SHOW && !processSupplier.getSettingsParser().getInputValues().isEmpty() && !SettingsWizard.openEditPreferencesWizard(shell, preferences)) {
            return null;
        }
        return preferences;
    }

    public static <T> ProcessorPreferences<T> getWorkspacePreferences(IProcessSupplier<T> supplier) {
        return new NodeProcessorPreferences(supplier, SettingsWizard.getStorage().node(supplier.getId()));
    }

    public static Collection<ProcessorPreferences<?>> getAllPreferences(ProcessSupplierContext context) {
        ArrayList result = new ArrayList();
        try {
            String[] childrenNames;
            IEclipsePreferences storage = SettingsWizard.getStorage();
            String[] stringArray = childrenNames = storage.childrenNames();
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessSupplier processorSupplier;
                String name = stringArray[n2];
                Preferences node = storage.node(name);
                if (node.keys().length != 0 && (processorSupplier = context.getSupplier(name)) != null) {
                    result.add((ProcessorPreferences<?>)new NodeProcessorPreferences(processorSupplier, node));
                }
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return result;
    }

    private static IEclipsePreferences getStorage() {
        if (preferences == null) {
            preferences = InstanceScope.INSTANCE.getNode(IProcessSupplier.class.getName());
        }
        return preferences;
    }
}

