/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation;

import org.eclipse.chemclipse.model.quantitation.IResponseSignal;
import org.eclipse.chemclipse.model.quantitation.ResponseSignal;
import org.eclipse.chemclipse.support.util.ValueParserSupport;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class ResponseSignalValidator
extends ValueParserSupport
implements IValidator {
    public static final String DEMO = "TIC | 1.5 | 289893.38";
    private static final String DELIMITER = "|";
    private static final String ERROR_TARGET = "Please enter a response signal, e.g.: TIC | 1.5 | 289893.38";
    private double signal;
    private double concentration;
    private double response;

    public IStatus validate(Object value) {
        String message = null;
        if (value == null) {
            message = ERROR_TARGET;
        } else if (value instanceof String) {
            String text = ((String)value).trim();
            if ("".equals(text.trim())) {
                message = ERROR_TARGET;
            } else {
                String[] values = text.trim().split("\\|");
                String signalValue = this.parseString(values, 0);
                this.signal = "TIC".equals(signalValue) ? 0.0 : this.parseDouble(values, 0);
                this.concentration = this.parseDouble(values, 1);
                this.response = this.parseDouble(values, 2);
            }
        } else {
            message = ERROR_TARGET;
        }
        if (message != null) {
            return ValidationStatus.error((String)message);
        }
        return ValidationStatus.ok();
    }

    public IResponseSignal getResponseSignal() {
        return new ResponseSignal(this.signal, this.concentration, this.response);
    }
}

