/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.model.quantitation.IQuantitationPeak;
import org.eclipse.chemclipse.support.ui.swt.AbstractRecordTableComparator;
import org.eclipse.chemclipse.support.ui.swt.IRecordTableComparator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.PeakDataSupport;
import org.eclipse.jface.viewers.Viewer;

public class QuantPeaksTableComparator
extends AbstractRecordTableComparator
implements IRecordTableComparator {
    private PeakDataSupport peakDataSupport = new PeakDataSupport();

    public int compare(Viewer viewer, Object e1, Object e2) {
        int sortOrder = 0;
        if (e1 instanceof IQuantitationPeak && e2 instanceof IQuantitationPeak) {
            IQuantitationPeak entry1 = (IQuantitationPeak)e1;
            IQuantitationPeak entry2 = (IQuantitationPeak)e2;
            switch (this.getPropertyIndex()) {
                case 0: {
                    sortOrder = Double.compare(entry2.getConcentration(), entry1.getConcentration());
                    break;
                }
                case 1: {
                    sortOrder = entry2.getConcentrationUnit().compareTo(entry1.getConcentrationUnit());
                    break;
                }
                case 2: {
                    sortOrder = this.peakDataSupport.getType(entry2.getReferencePeak()).compareTo(this.peakDataSupport.getType(entry1.getReferencePeak()));
                    break;
                }
                default: {
                    sortOrder = 0;
                }
            }
        }
        if (this.getDirection() == 0) {
            sortOrder = -sortOrder;
        }
        return sortOrder;
    }
}

