/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.model.quantitation.IRetentionIndexWindow;
import org.eclipse.chemclipse.model.quantitation.IRetentionTimeWindow;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class QuantCompoundLabelProvider
extends AbstractChemClipseLabelProvider {
    public static final String NAME = "Name";
    public static final String CHEMICAL_CLASS = "Chemical Class";
    public static final String CONCENTRATION_UNIT = "Concentration Unit";
    public static final String CALIBRATION_METHOD = "Calibration Method";
    public static final String CROSS_ZERO = "Cross Zero";
    public static final String USE_TIC = "Use TIC";
    public static final String RETENTION_TIME = "Retention Time (RT)";
    public static final String RETENTION_TIME_LOWER = "RT (-)";
    public static final String RETENTION_TIME_UPPER = "RT (+)";
    public static final String RETENTION_INDEX = "Retention Index (RI)";
    public static final String RETENTION_INDEX_LOWER = "RI (-)";
    public static final String RETENTION_INDEX_UPPER = "RI (+)";
    public static final String[] TITLES = new String[]{"Name", "Chemical Class", "Concentration Unit", "Calibration Method", "Cross Zero", "Use TIC", "Retention Time (RT)", "RT (-)", "RT (+)", "Retention Index (RI)", "RI (-)", "RI (+)"};
    public static final int[] BOUNDS = new int[]{200, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100};

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        if (columnIndex == 4) {
            if (element instanceof IQuantitationCompound) {
                IQuantitationCompound quantitationCompound = (IQuantitationCompound)element;
                String fileName = quantitationCompound.isCrossZero() ? "org.eclipse.chemclipse.rcp.ui.icons/selected.gif" : "org.eclipse.chemclipse.rcp.ui.icons/deselected.gif";
                return ApplicationImageFactory.getInstance().getImage(fileName, "16x16");
            }
        } else if (columnIndex == 5 && element instanceof IQuantitationCompound) {
            IQuantitationCompound quantitationCompound = (IQuantitationCompound)element;
            String fileName = quantitationCompound.isUseTIC() ? "org.eclipse.chemclipse.rcp.ui.icons/selected.gif" : "org.eclipse.chemclipse.rcp.ui.icons/deselected.gif";
            return ApplicationImageFactory.getInstance().getImage(fileName, "16x16");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IQuantitationCompound) {
            IQuantitationCompound compound = (IQuantitationCompound)element;
            IRetentionTimeWindow retentionTimeWindow = compound.getRetentionTimeWindow();
            IRetentionIndexWindow retentionIndexWindow = compound.getRetentionIndexWindow();
            switch (columnIndex) {
                case 0: {
                    text = compound.getName();
                    break;
                }
                case 1: {
                    text = compound.getChemicalClass();
                    break;
                }
                case 2: {
                    text = compound.getConcentrationUnit();
                    break;
                }
                case 3: {
                    text = compound.getCalibrationMethod().toString();
                    break;
                }
                case 4: {
                    text = "";
                    break;
                }
                case 5: {
                    text = "";
                    break;
                }
                case 6: {
                    text = decimalFormat.format((double)retentionTimeWindow.getRetentionTime() / 60000.0);
                    break;
                }
                case 7: {
                    text = decimalFormat.format((double)retentionTimeWindow.getAllowedNegativeDeviation() / 60000.0);
                    break;
                }
                case 8: {
                    text = decimalFormat.format((double)retentionTimeWindow.getAllowedPositiveDeviation() / 60000.0);
                    break;
                }
                case 9: {
                    text = decimalFormat.format(retentionIndexWindow.getRetentionIndex());
                    break;
                }
                case 10: {
                    text = decimalFormat.format(retentionIndexWindow.getAllowedNegativeDeviation());
                    break;
                }
                case 11: {
                    text = decimalFormat.format(retentionIndexWindow.getAllowedPositiveDeviation());
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/quantifySelectedPeak.gif", "16x16");
    }
}

