/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.core.ITargetSupplier;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.support.ui.swt.AbstractRecordTableComparator;
import org.eclipse.chemclipse.support.ui.swt.IRecordTableComparator;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramPeakWSD;
import org.eclipse.jface.viewers.Viewer;

public class PeakScanListTableComparator
extends AbstractRecordTableComparator
implements IRecordTableComparator {
    private double chromatogramPeakArea = 0.0;
    private final TargetExtendedComparator comparator = new TargetExtendedComparator(SortOrder.DESC);

    public void setChromatogramPeakArea(double chromatogramPeakArea) {
        this.chromatogramPeakArea = chromatogramPeakArea;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int sortOrder = 0;
        Object object1 = null;
        Object object2 = null;
        if (e1 instanceof IPeak) {
            object1 = e1;
        } else if (e1 instanceof IScan) {
            object1 = e1;
        }
        if (e2 instanceof IPeak) {
            object2 = e2;
        } else if (e2 instanceof IScan) {
            object2 = e2;
        }
        if (object1 != null && object2 != null) {
            sortOrder = this.getSortOrder(object1, object2);
        }
        if (this.getDirection() == 0) {
            sortOrder = -sortOrder;
        }
        return sortOrder;
    }

    private int getSortOrder(Object object1, Object object2) {
        int sortOrder = 0;
        switch (this.getPropertyIndex()) {
            case 0: {
                sortOrder = Boolean.compare(this.isActiveForAnalysis(object2), this.isActiveForAnalysis(object1));
                break;
            }
            case 1: {
                sortOrder = this.getType(object2).compareTo(this.getType(object1));
                break;
            }
            case 2: {
                sortOrder = Integer.compare(this.getRetentionTime(object2), this.getRetentionTime(object1));
                break;
            }
            case 3: {
                sortOrder = Integer.compare(this.getRelativeRetentionTime(object2), this.getRelativeRetentionTime(object1));
                break;
            }
            case 4: {
                sortOrder = Float.compare(this.getRetentionIndex(object2), this.getRetentionIndex(object1));
                break;
            }
            case 5: {
                sortOrder = Double.compare(this.getIntegratedArea(object2), this.getIntegratedArea(object1));
                break;
            }
            case 6: {
                sortOrder = Integer.compare(this.getStartRetentionTime(object2), this.getStartRetentionTime(object1));
                break;
            }
            case 7: {
                sortOrder = Integer.compare(this.getStopRetentionTime(object2), this.getStopRetentionTime(object1));
                break;
            }
            case 8: {
                Integer.compare(this.getWidth(object2), this.getWidth(object1));
                break;
            }
            case 9: 
            case 10: {
                if (object1 instanceof IChromatogramPeakMSD && object2 instanceof IChromatogramPeakMSD) {
                    IChromatogramPeakMSD chromatogramPeak1 = (IChromatogramPeakMSD)object1;
                    IChromatogramPeakMSD chromatogramPeak2 = (IChromatogramPeakMSD)object2;
                    switch (this.getPropertyIndex()) {
                        case 9: {
                            sortOrder = chromatogramPeak2.getScanMax() - chromatogramPeak1.getScanMax();
                            break;
                        }
                        case 10: {
                            sortOrder = Float.compare(chromatogramPeak2.getSignalToNoiseRatio(), chromatogramPeak1.getSignalToNoiseRatio());
                        }
                    }
                    break;
                }
                if (object1 instanceof IChromatogramPeakCSD && object2 instanceof IChromatogramPeakCSD) {
                    IChromatogramPeakCSD chromatogramPeak1 = (IChromatogramPeakCSD)object1;
                    IChromatogramPeakCSD chromatogramPeak2 = (IChromatogramPeakCSD)object2;
                    switch (this.getPropertyIndex()) {
                        case 9: {
                            sortOrder = chromatogramPeak2.getScanMax() - chromatogramPeak1.getScanMax();
                            break;
                        }
                        case 10: {
                            sortOrder = Float.compare(chromatogramPeak2.getSignalToNoiseRatio(), chromatogramPeak1.getSignalToNoiseRatio());
                        }
                    }
                    break;
                }
                if (!(object1 instanceof IChromatogramPeakWSD) || !(object2 instanceof IChromatogramPeakWSD)) break;
                IChromatogramPeakWSD chromatogramPeak1 = (IChromatogramPeakWSD)object1;
                IChromatogramPeakWSD chromatogramPeak2 = (IChromatogramPeakWSD)object2;
                switch (this.getPropertyIndex()) {
                    case 9: {
                        sortOrder = chromatogramPeak2.getScanMax() - chromatogramPeak1.getScanMax();
                        break;
                    }
                    case 10: {
                        sortOrder = Float.compare(chromatogramPeak2.getSignalToNoiseRatio(), chromatogramPeak1.getSignalToNoiseRatio());
                    }
                }
                break;
            }
            case 11: {
                sortOrder = Float.compare(this.getLeading(object2), this.getLeading(object1));
                break;
            }
            case 12: {
                sortOrder = Float.compare(this.getTailing(object2), this.getTailing(object1));
                break;
            }
            case 13: {
                sortOrder = this.getModelDescription(object2).compareTo(this.getModelDescription(object1));
                break;
            }
            case 14: {
                sortOrder = Integer.compare(this.getSuggestedNumberOfComponents(object2), this.getSuggestedNumberOfComponents(object1));
                break;
            }
            case 15: {
                ILibraryInformation libraryInformation1 = this.getLibraryInformation(object1);
                ILibraryInformation libraryInformation2 = this.getLibraryInformation(object2);
                if (libraryInformation1 == null || libraryInformation2 == null) break;
                sortOrder = libraryInformation2.getName().compareTo(libraryInformation1.getName());
                break;
            }
            case 16: {
                if (this.chromatogramPeakArea > 0.0) {
                    double factor = 100.0 / this.chromatogramPeakArea;
                    double peakAreaPercent1 = factor * this.getIntegratedArea(object1);
                    double peakAreaPercent2 = factor * this.getIntegratedArea(object2);
                    return Double.compare(peakAreaPercent2, peakAreaPercent1);
                }
                sortOrder = 0;
                break;
            }
            case 17: {
                sortOrder = Integer.compare(this.getInternalStandards(object2), this.getInternalStandards(object1));
                break;
            }
            case 18: {
                sortOrder = this.getClassifier(object2).size() - this.getClassifier(object1).size();
            }
        }
        return sortOrder;
    }

    private boolean isActiveForAnalysis(Object object) {
        if (object instanceof IPeak) {
            return ((IPeak)object).isActiveForAnalysis();
        }
        return false;
    }

    private String getType(Object object) {
        if (object instanceof IPeak) {
            return "PEAK";
        }
        return "SCAN";
    }

    private int getRetentionTime(Object object) {
        if (object instanceof IPeak) {
            return ((IPeak)object).getPeakModel().getPeakMaximum().getRetentionTime();
        }
        return ((IScan)object).getRetentionTime();
    }

    private int getRelativeRetentionTime(Object object) {
        if (object instanceof IPeak) {
            return ((IPeak)object).getPeakModel().getPeakMaximum().getRelativeRetentionTime();
        }
        return ((IScan)object).getRelativeRetentionTime();
    }

    private float getRetentionIndex(Object object) {
        if (object instanceof IPeak) {
            return ((IPeak)object).getPeakModel().getPeakMaximum().getRetentionIndex();
        }
        return ((IScan)object).getRetentionIndex();
    }

    private double getIntegratedArea(Object object) {
        if (object instanceof IPeak) {
            return ((IPeak)object).getIntegratedArea();
        }
        return 0.0;
    }

    private int getStartRetentionTime(Object object) {
        if (object instanceof IPeak) {
            return ((IPeak)object).getPeakModel().getStartRetentionTime();
        }
        return 0;
    }

    private int getStopRetentionTime(Object object) {
        if (object instanceof IPeak) {
            return ((IPeak)object).getPeakModel().getStopRetentionTime();
        }
        return 0;
    }

    private int getWidth(Object object) {
        if (object instanceof IPeak) {
            return ((IPeak)object).getPeakModel().getWidthBaselineByInflectionPoints();
        }
        return 0;
    }

    private float getLeading(Object object) {
        if (object instanceof IPeak) {
            return ((IPeak)object).getPeakModel().getLeading();
        }
        return 0.0f;
    }

    private float getTailing(Object object) {
        if (object instanceof IPeak) {
            return ((IPeak)object).getPeakModel().getTailing();
        }
        return 0.0f;
    }

    private String getModelDescription(Object object) {
        if (object instanceof IPeak) {
            return ((IPeak)object).getModelDescription();
        }
        return "";
    }

    private int getSuggestedNumberOfComponents(Object object) {
        if (object instanceof IPeak) {
            return ((IPeak)object).getSuggestedNumberOfComponents();
        }
        return 0;
    }

    private int getInternalStandards(Object object) {
        if (object instanceof IPeak) {
            return ((IPeak)object).getInternalStandards().size();
        }
        return 0;
    }

    private Collection<String> getClassifier(Object object) {
        if (object instanceof IPeak) {
            return ((IPeak)object).getClassifier();
        }
        return Collections.emptyList();
    }

    private ILibraryInformation getLibraryInformation(Object object) {
        if (object instanceof ITargetSupplier) {
            return IIdentificationTarget.getBestLibraryInformation((Set)((ITargetSupplier)object).getTargets(), (Comparator)this.comparator);
        }
        return null;
    }
}

