/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class IntegrationAreaLabelProvider
extends AbstractChemClipseLabelProvider {
    public static final String[] TITLES = new String[]{"Area", "Trace"};
    public static final int[] BOUNDS = new int[]{300, 300};

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IIntegrationEntry) {
            IIntegrationEntry integrationEntry = (IIntegrationEntry)element;
            switch (columnIndex) {
                case 0: {
                    text = decimalFormat.format(integrationEntry.getIntegratedArea());
                    break;
                }
                case 1: {
                    IIntegrationEntry integrationEntryMSD = (IIntegrationEntry)element;
                    double signal = integrationEntryMSD.getSignal();
                    if (signal != 0.0) {
                        text = decimalFormat.format(signal);
                        break;
                    }
                    text = "TIC";
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/integrationResults.gif", "16x16");
    }
}

