/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.editors;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramConverterSupport;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.support.settings.UserManagement;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables.ChromatogramExportRunnable;
import org.eclipse.chemclipse.wsd.converter.chromatogram.ChromatogramConverterWSD;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ChromatogramFileSupport {
    private static final Logger logger = Logger.getLogger(ChromatogramFileSupport.class);

    private ChromatogramFileSupport() {
    }

    public static boolean saveChromatogram(Shell shell, IChromatogram chromatogram, DataType dataType) throws NoConverterAvailableException {
        return ChromatogramFileSupport.saveChromatogram(shell, chromatogram, dataType, UserManagement.getUserHome());
    }

    public static boolean saveChromatogram(Shell shell, IChromatogram chromatogram, DataType dataType, String filterPath) throws NoConverterAvailableException {
        if (chromatogram == null || shell == null) {
            return false;
        }
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setFilterPath(filterPath);
        fileDialog.setFileName(chromatogram.getName());
        fileDialog.setText("Save Chromatogram As...");
        fileDialog.setOverwrite(true);
        IChromatogramConverterSupport chromatogramConverterSupport = ChromatogramFileSupport.getChromatogramConvertSupport(dataType);
        if (chromatogramConverterSupport != null) {
            int key;
            Map<Integer, ISupplier> exportSupplierMap = ChromatogramFileSupport.setExportConverter(chromatogramConverterSupport, fileDialog);
            String filename = fileDialog.open();
            if (filename != null && exportSupplierMap.containsKey(key = fileDialog.getFilterIndex())) {
                ISupplier selectedSupplier = exportSupplierMap.get(key);
                String filePath = String.valueOf(fileDialog.getFilterPath()) + File.separator + fileDialog.getFileName();
                boolean overwrite = fileDialog.getOverwrite();
                ChromatogramFileSupport.validateAndExportFile(shell, chromatogram, dataType, filePath, overwrite, selectedSupplier);
                return true;
            }
        }
        return false;
    }

    private static Map<Integer, ISupplier> setExportConverter(IChromatogramConverterSupport chromatogramConverterSupport, FileDialog fileDialog) throws NoConverterAvailableException {
        HashMap<Integer, ISupplier> exportSupplierMap = new HashMap<Integer, ISupplier>();
        String[] names = chromatogramConverterSupport.getExportableFilterNames();
        String[] extensions = chromatogramConverterSupport.getExportableFilterExtensions();
        List suppliers = chromatogramConverterSupport.getExportSupplier();
        if (extensions.length != names.length) {
            throw new NoConverterAvailableException("The size of extensions and names is unequal.");
        }
        String promotedName = null;
        String promotedExtension = null;
        HashMap<String, String> exportFilter = new HashMap<String, String>();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            String extension = extensions[i];
            if (extension.contains(".ocb")) {
                promotedName = name;
                promotedExtension = extension;
            } else {
                exportFilter.put(name, extension);
            }
            ++i;
        }
        ArrayList keys = new ArrayList(exportFilter.keySet());
        Collections.sort(keys);
        boolean promotionAvailable = promotedName != null;
        int size = keys.size() + (promotionAvailable ? 1 : 0);
        String[] extensionsSorted = new String[size];
        String[] namesSorted = new String[size];
        int offset = 0;
        if (promotionAvailable) {
            namesSorted[offset] = promotedName;
            extensionsSorted[offset] = promotedExtension;
            exportSupplierMap.put(offset, ChromatogramFileSupport.getSupplier(promotedName, suppliers));
            ++offset;
        }
        int i2 = 0;
        while (i2 < keys.size()) {
            String key = (String)keys.get(i2);
            int index = i2 + offset;
            namesSorted[index] = key;
            extensionsSorted[index] = (String)exportFilter.get(key);
            exportSupplierMap.put(index, ChromatogramFileSupport.getSupplier(key, suppliers));
            ++i2;
        }
        fileDialog.setFilterNames(namesSorted);
        fileDialog.setFilterExtensions(extensionsSorted);
        return exportSupplierMap;
    }

    private static ISupplier getSupplier(String filterName, List<ISupplier> suppliers) {
        for (ISupplier supplier : suppliers) {
            if (!supplier.isExportable() || !supplier.getFilterName().equals(filterName)) continue;
            return supplier;
        }
        return null;
    }

    private static IChromatogramConverterSupport getChromatogramConvertSupport(DataType dataType) {
        IChromatogramConverterSupport converterSupport = null;
        switch (dataType) {
            case MSD_NOMINAL: 
            case MSD_TANDEM: 
            case MSD_HIGHRES: 
            case MSD: {
                converterSupport = ChromatogramConverterMSD.getInstance().getChromatogramConverterSupport();
                break;
            }
            case CSD: {
                converterSupport = ChromatogramConverterCSD.getInstance().getChromatogramConverterSupport();
                break;
            }
            case WSD: {
                converterSupport = ChromatogramConverterWSD.getInstance().getChromatogramConverterSupport();
            }
        }
        return converterSupport;
    }

    public static void writeFile(Shell shell, File file, IChromatogram chromatogram, ISupplier supplier, DataType dataType) {
        if (file == null || chromatogram == null || supplier == null) {
            return;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        ChromatogramExportRunnable runnable = new ChromatogramExportRunnable(file, chromatogram, supplier, dataType);
        try {
            dialog.run(true, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        File data = runnable.getData();
        if (data == null) {
            MessageDialog.openInformation((Shell)shell, (String)"Save Chromatogram", (String)"There is not suitable chromatogram converter available.");
        }
    }

    private static void validateAndExportFile(Shell shell, IChromatogram chromatogram, DataType dataType, String filePath, boolean overwrite, ISupplier selectedSupplier) {
        File chromatogramFolder = null;
        boolean folderExists = false;
        boolean isDirectory = false;
        String filename = filePath;
        if (selectedSupplier != null) {
            String directoryExtension = selectedSupplier.getDirectoryExtension();
            if (directoryExtension != "") {
                isDirectory = true;
                filename = ChromatogramFileSupport.removeFileExtensions(filename, selectedSupplier);
                chromatogramFolder = new File(filename = filename.concat(selectedSupplier.getDirectoryExtension()));
                if (chromatogramFolder.exists()) {
                    folderExists = true;
                    overwrite = MessageDialog.openQuestion((Shell)shell, (String)"Overwrite", (String)("Would you like to overwrite the chromatogram " + chromatogramFolder.toString() + "?"));
                }
                if (overwrite && !folderExists) {
                    chromatogramFolder.mkdir();
                }
            } else {
                File chromatogramFile;
                String filenameDialog;
                filename = ChromatogramFileSupport.removeFileExtensions(filename, selectedSupplier);
                if (!(filename = filename.concat(selectedSupplier.getFileExtension())).equals(filenameDialog = filePath) && (chromatogramFile = new File(filename)).exists()) {
                    overwrite = MessageDialog.openQuestion((Shell)shell, (String)"Overwrite", (String)("Would you like to overwrite the chromatogram " + chromatogramFile.toString() + "?"));
                }
            }
            if (overwrite) {
                if (isDirectory) {
                    if (!folderExists && chromatogramFolder != null) {
                        chromatogramFolder.mkdir();
                    }
                } else {
                    String fileExtension = selectedSupplier.getFileExtension();
                    if (!filename.endsWith(fileExtension)) {
                        filename = String.valueOf(filename) + fileExtension;
                    }
                }
                ChromatogramFileSupport.writeFile(shell, new File(filename), chromatogram, selectedSupplier, dataType);
            }
        } else {
            MessageDialog.openInformation((Shell)shell, (String)"Chromatogram Converter", (String)"The requested chromatogram converter does not exists.");
        }
    }

    private static String removeFileExtensions(String filePath, ISupplier supplier) {
        int start = 0;
        int stop = 0;
        if (supplier.getDirectoryExtension().equals("")) {
            String fileExtension = supplier.getFileExtension();
            if (filePath.endsWith(fileExtension) || filePath.endsWith(fileExtension.toLowerCase()) || filePath.endsWith(fileExtension.toUpperCase())) {
                stop = filePath.length() - fileExtension.length();
                filePath = filePath.substring(start, stop);
            }
        } else {
            String directoryExtension = supplier.getDirectoryExtension();
            if (filePath.endsWith(directoryExtension) || filePath.endsWith(directoryExtension.toLowerCase()) || filePath.endsWith(directoryExtension.toUpperCase())) {
                stop = filePath.length() - directoryExtension.length();
                filePath = filePath.substring(start, stop);
            }
        }
        return filePath;
    }
}

