/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.editors;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.converter.quantitation.QuantDBConverter;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.handler.IModificationHandler;
import org.eclipse.chemclipse.model.handler.ISaveHandler;
import org.eclipse.chemclipse.model.quantitation.IQuantitationDatabase;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.ux.extension.ui.editors.IQuantitationDatabaseEditor;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables.QuantDBImportRunnable;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.AbstractDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ExtendedQuantCompoundListUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class QuantitationDatabaseEditor
extends AbstractDataUpdateSupport
implements IDataUpdateSupport,
IQuantitationDatabaseEditor {
    private static final Logger logger = Logger.getLogger(QuantitationDatabaseEditor.class);
    public static final String ID = "org.eclipse.chemclipse.ux.extension.xxd.ui.part.quantitationDatabaseEditor";
    public static final String CONTRIBUTION_URI = "bundleclass://org.eclipse.chemclipse.ux.extension.xxd.ui/org.eclipse.chemclipse.ux.extension.xxd.ui.editors.QuantitationDatabaseEditor";
    public static final String ICON_URI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/database.gif";
    public static final String TOOLTIP = "Quantitation Editor";
    private final MPart part;
    private final MDirtyable dirtyable;
    private File quantitationDatabaseFile;
    private IQuantitationDatabase quantitationDatabase;
    private ExtendedQuantCompoundListUI extendedQuantCompoundListUI;
    private final Shell shell;

    @Inject
    public QuantitationDatabaseEditor(Composite parent, MPart part, MDirtyable dirtyable, Shell shell) {
        super(part);
        this.part = part;
        this.dirtyable = dirtyable;
        this.shell = shell;
        this.initialize(parent);
    }

    @Override
    public void registerEvents() {
    }

    @Override
    public void updateObjects(List<Object> objects, String topic) {
        objects.size();
    }

    @Focus
    public void setFocus() {
    }

    @Override
    @PreDestroy
    protected void preDestroy() {
        super.preDestroy();
        EModelService modelService = ModelSupportAddon.getModelService();
        if (modelService != null) {
            MApplication application = ModelSupportAddon.getApplication();
            final MPartStack partStack = (MPartStack)modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)application);
            this.part.setToBeRendered(false);
            this.part.setVisible(false);
            DisplayUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    partStack.getChildren().remove(QuantitationDatabaseEditor.this.part);
                }
            });
        }
        System.gc();
    }

    @Persist
    public void save() {
        if (this.quantitationDatabase != null && this.quantitationDatabaseFile != null) {
            QuantDBConverter.convert((File)this.quantitationDatabaseFile, (IQuantitationDatabase)this.quantitationDatabase, (String)"org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.quantitationDatabaseSupplier", (IProgressMonitor)new NullProgressMonitor());
            this.dirtyable.setDirty(false);
        }
    }

    public boolean saveAs() {
        return false;
    }

    public IQuantitationDatabase getQuantitationDatabase() {
        return this.quantitationDatabase;
    }

    private void initialize(Composite parent) {
        this.createEditorPages(parent);
        this.dirtyable.setDirty(true);
        this.quantitationDatabase = this.loadQuantitationDatabase();
        this.extendedQuantCompoundListUI.update(this.quantitationDatabase);
    }

    private void createEditorPages(Composite parent) {
        this.createPage(parent);
    }

    private void createPage(Composite parent) {
        this.extendedQuantCompoundListUI = new ExtendedQuantCompoundListUI(parent);
        this.extendedQuantCompoundListUI.setModificationHandler(new IModificationHandler(){

            public void setDirty(boolean dirty) {
                QuantitationDatabaseEditor.this.dirtyable.setDirty(dirty);
            }
        });
        this.extendedQuantCompoundListUI.setSaveHandler(new ISaveHandler(){

            public void doSave() {
                QuantitationDatabaseEditor.this.save();
            }
        });
    }

    private synchronized IQuantitationDatabase loadQuantitationDatabase() {
        IQuantitationDatabase quantitationDatabase = null;
        Object object = this.part.getObject();
        if (object instanceof Map) {
            Map map = (Map)object;
            File file = new File((String)map.get("File"));
            boolean batch = (Boolean)map.get("Batch");
            quantitationDatabase = this.loadQuantitationDatabase(file, batch);
        }
        return quantitationDatabase;
    }

    private IQuantitationDatabase loadQuantitationDatabase(File file, boolean batch) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
        QuantDBImportRunnable runnable = new QuantDBImportRunnable(file);
        try {
            boolean fork = !batch;
            dialog.run(fork, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        this.quantitationDatabaseFile = file;
        return runnable.getQuantitationDatabase();
    }
}

