/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.runtime;

import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.chemclipse.support.runtime.AbstractRuntimeSupport;
import org.eclipse.chemclipse.support.runtime.IWineRuntimeSupport;

public abstract class AbstractWineRuntimeSupport
extends AbstractRuntimeSupport
implements IWineRuntimeSupport {
    private String wineEnvironment = "";
    private String wineApplication = "";

    public AbstractWineRuntimeSupport(String application, String parameter) throws FileNotFoundException {
        super(application, parameter);
        this.extractValues();
    }

    @Override
    public String getWineEnvironment() {
        return this.wineEnvironment;
    }

    @Override
    public String getWineApplication() {
        return this.wineApplication;
    }

    private void extractValues() {
        String DOSDEVICES = String.valueOf(File.separator) + "dosdevices" + File.separator;
        String DRIVE = String.valueOf(File.separator) + "drive_";
        String[] parts = null;
        String nistApplication = this.getApplication();
        if (nistApplication.contains(DOSDEVICES)) {
            parts = nistApplication.split(DOSDEVICES);
        } else if (nistApplication.contains(DRIVE)) {
            parts = nistApplication.split(DRIVE);
            parts[1] = parts[1].replaceFirst("/", ":/");
        }
        if (parts != null) {
            this.wineEnvironment = parts[0];
            this.wineApplication = parts[1].replace("/", "\\");
        }
    }
}

