/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.l10n;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.support.preferences.SupportPreferences;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Messages {
    public static final String NO_ENTRY = "n.a.";
    private static final Logger logger = LoggerFactory.getLogger(Messages.class);
    private Map<String, String> messageMap;
    private static final String COMMENT = "#";
    private static final String DELIMITER = "=";
    private static final String CHARSET = "UTF-8";

    public Messages(Bundle bundle) {
        this.initializeMessageMap(bundle);
    }

    public String getMessage(String key, String ... args) {
        String message = this.messageMap.get(key);
        if (message == null) {
            message = NO_ENTRY;
            logger.warn("n.a. > " + key);
        } else if (args != null && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                message = message.replaceAll("\\{" + i + "\\}", args[i]);
                ++i;
            }
        }
        return message;
    }

    private void initializeMessageMap(Bundle bundle) {
        String[] values;
        String language = System.getProperty("user.language");
        String country = System.getProperty("user.country");
        String userSelection = SupportPreferences.getApplicationLanguage();
        if (userSelection != null && !userSelection.equals("") && (values = userSelection.split("_")).length == 2) {
            language = values[0].trim();
            country = values[1].trim();
        }
        this.messageMap = new HashMap<String, String>();
        logger.info(String.valueOf(language) + "_" + country);
        String path = "OSGI-INF/l10n/bundle_" + language + "_" + country + ".properties";
        this.parseFile(path, bundle, false);
        path = "OSGI-INF/l10n/bundle_" + language + ".properties";
        this.parseFile(path, bundle, true);
        path = "OSGI-INF/l10n/bundle.properties";
        this.parseFile(path, bundle, true);
    }

    private void parseFile(String path, Bundle bundle, boolean checkKey) {
        try {
            URL url = FileLocator.toFileURL((URL)bundle.getEntry(path));
            if (url != null) {
                String pathname = url.toString().replace("file:", "");
                File file = new File(pathname);
                if (file.exists()) {
                    logger.trace("Parsing messages from file {}", (Object)file);
                    this.addMessages(file, checkKey);
                } else {
                    logger.warn("File doesn't exists: {}", (Object)file);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addMessages(File file, boolean checkKey) {
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CHARSET));
            while ((line = bufferedReader.readLine()) != null) {
                String[] message;
                if (line.startsWith(COMMENT) || (message = line.split(DELIMITER, 2)).length != 2) continue;
                String key = message[0].trim();
                String value = message[1].trim();
                boolean addKey = true;
                if (checkKey && this.messageMap.containsKey(key)) {
                    addKey = false;
                }
                if (!addKey) continue;
                this.messageMap.put(key, value);
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            logger.warn("reading file {} failed", (Object)file, (Object)e);
        }
    }
}

