/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.provider;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class LazyFileExplorerContentProvider
implements ILazyTreeContentProvider,
FileFilter {
    public static final int MAX_CACHE_SIZE = Integer.parseInt(System.getProperty("fileexplorer.max_cache_size", "1000"));
    private static final File[] NO_CHILD = new File[0];
    private TreeViewer viewer;
    private File[] roots;
    private final Map<File, File[]> cache = new FileCache<File[]>();

    public void updateElement(Object parent, int index) {
        File[] childs;
        Object[] objects;
        if (this.viewer == null) {
            return;
        }
        Object child = null;
        if (parent instanceof Object[] && index < (objects = (Object[])parent).length) {
            child = objects[index];
        }
        if (parent instanceof File && index < (childs = this.getChilds((File)parent)).length) {
            child = childs[index];
        }
        if (child instanceof File) {
            this.viewer.replace(parent, index, child);
            File file = (File)child;
            if (file.isDirectory()) {
                this.viewer.setHasChildren((Object)file, true);
                this.cache.remove(file);
            } else {
                this.viewer.setChildCount((Object)file, 0);
            }
        }
    }

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        TreeViewer treeViewer;
        if (newViewer instanceof TreeViewer) {
            treeViewer = (TreeViewer)newViewer;
            if ((treeViewer.getTree().getStyle() & 0x10000000) == 0) {
                throw new IllegalArgumentException("Treeviewer must be constructed with SWT.VIRTUAL flag!");
            }
            if (newInput instanceof File) {
                newInput = new File[]{(File)newInput};
            }
            if (newInput != null && !(newInput instanceof File[])) {
                throw new IllegalArgumentException("Input must be an Array of Files");
            }
            this.roots = newInput;
        } else {
            throw new IllegalArgumentException("Viewer must be a TreeViewer!");
        }
        this.viewer = treeViewer;
    }

    public void refresh(File file) {
        this.cache.remove(file);
        if (this.viewer != null) {
            this.viewer.refresh((Object)file);
        }
    }

    public void dispose() {
        this.cache.clear();
        super.dispose();
    }

    public void updateChildCount(Object element, int currentChildCount) {
        if (this.viewer == null) {
            return;
        }
        if (element instanceof File) {
            File file = (File)element;
            int childs = this.getChilds(file).length;
            if (currentChildCount != childs) {
                this.viewer.setChildCount(element, childs);
            }
            return;
        }
        if (element instanceof Object[]) {
            Object[] objects = (Object[])element;
            int childs = objects.length;
            if (currentChildCount != childs) {
                this.viewer.setChildCount(element, childs);
            }
            return;
        }
    }

    private File[] getChilds(final File file) {
        if (file.isDirectory()) {
            File[] cached = this.cache.get(file);
            if (cached != null) {
                return cached;
            }
            Display display = this.viewer.getControl().getDisplay();
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                @Override
                public void run() {
                    Object[] childs = file.listFiles(LazyFileExplorerContentProvider.this);
                    if (childs != null) {
                        Arrays.sort(childs);
                        LazyFileExplorerContentProvider.this.cache.put(file, childs);
                    } else {
                        LazyFileExplorerContentProvider.this.cache.put(file, NO_CHILD);
                    }
                }
            });
            return this.cache.get(file);
        }
        return NO_CHILD;
    }

    public Object getParent(Object element) {
        if (element instanceof File) {
            File file = (File)element;
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                return this.roots;
            }
            if (this.roots != null) {
                String realPath = LazyFileExplorerContentProvider.getRealPath(file);
                File[] fileArray = this.roots;
                int n = this.roots.length;
                int n2 = 0;
                while (n2 < n) {
                    File root = fileArray[n2];
                    if (realPath.equals(LazyFileExplorerContentProvider.getRealPath(root))) {
                        return this.roots;
                    }
                    ++n2;
                }
            }
            return parentFile;
        }
        return null;
    }

    @Override
    public boolean accept(File file) {
        return !file.isHidden() && !file.getName().startsWith(".") && file.canRead();
    }

    private static String getRealPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    protected static final class FileCache<T>
    extends LinkedHashMap<File, T> {
        private static final long serialVersionUID = -5978638803700871374L;

        public FileCache() {
            super(MAX_CACHE_SIZE, 0.75f, true);
        }

        @Override
        public boolean removeEldestEntry(Map.Entry<File, T> eldest) {
            return this.size() > MAX_CACHE_SIZE;
        }
    }
}

