/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.chemclipse.processing.converter.AbstractSupplierFileIdentifier;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;
import org.eclipse.chemclipse.processing.converter.SupplierContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ISupplierFileIdentifier.class})
public class OSGiSupplierFileIdentifier
extends AbstractSupplierFileIdentifier
implements ISupplierFileIdentifier {
    private final List<SupplierContext> supplierContexts = new CopyOnWriteArrayList<SupplierContext>();

    public OSGiSupplierFileIdentifier() {
        super(new CopyOnWriteArrayList<ISupplier>());
    }

    @Override
    public String getType() {
        return "Chemclipse";
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addSupplierContext(SupplierContext supplierContext) {
        this.supplierContexts.add(supplierContext);
    }

    public void removeSupplierContext(SupplierContext supplierContext) {
        this.supplierContexts.remove(this.supplierContexts);
    }

    @Override
    public Collection<ISupplier> getSupplier() {
        ArrayList<ISupplier> list = new ArrayList<ISupplier>();
        for (SupplierContext context : this.supplierContexts) {
            list.addAll(context.getSupplier());
        }
        return list;
    }
}

