/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors;

import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakIdentificationBatchJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors.BatchProcessEditor;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors.IMultiEditorPage;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.peak.PeakListUI;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ResultsPage
implements IMultiEditorPage {
    private FormToolkit toolkit;
    private int pageIndex;
    private IPeakIdentificationBatchJob peakIdentificationBatchJob;
    private PeakListUI peakListUI;
    private SelectionUpdateListener selectionUpdateListener;
    private BatchProcessEditor editorPart;

    public ResultsPage(BatchProcessEditor editorPart, Composite container) {
        this.createPage(editorPart, container);
        this.editorPart = editorPart;
        this.selectionUpdateListener = new SelectionUpdateListener();
        this.selectionUpdateListener.setParent(this);
    }

    @Override
    public void setFocus() {
        IPeaks peaks = this.selectionUpdateListener.getPeaks();
        if (peaks != null) {
            this.update(peaks, true);
        }
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    @Override
    public void setPeakIdentificationBatchJob(IPeakIdentificationBatchJob peakIdentificationBatchJob) {
        if (peakIdentificationBatchJob != null) {
            this.peakIdentificationBatchJob = peakIdentificationBatchJob;
        }
    }

    public void update(IPeaks peaks, boolean forceReload) {
        if (this.editorPart.getActivePage() == this.getPageIndex() && peaks != null) {
            this.peakListUI.update(peaks, forceReload);
        }
    }

    public void clear() {
        this.peakListUI.clear();
    }

    private void createPage(BatchProcessEditor editorPart, Composite container) {
        container.setLayout((Layout)new FillLayout());
        Composite parent = new Composite(container, 0);
        parent.setLayout((Layout)new FillLayout());
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.createPeakListView(parent);
        this.pageIndex = editorPart.addPage((Control)parent);
    }

    private void createPeakListView(Composite parent) {
        this.peakListUI = new PeakListUI(parent, 0);
        ExtendedTableViewer tableViewer = this.peakListUI.getTableViewer();
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structuredSelection;
                Object element;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IPeakMSD) {
                    IPeakMSD peakMSD = (IPeakMSD)element;
                    IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
                    eventBroker.send("peak/xxd/update/selection", (Object)peakMSD);
                }
            }
        });
    }

    public static class SelectionUpdateListener {
        private static ResultsPage parentWidget;
        private static IPeaks evaluatedPeaks;

        static {
            evaluatedPeaks = null;
        }

        public void setParent(IMultiEditorPage parent) {
            if (parent instanceof ResultsPage) {
                parentWidget = (ResultsPage)parent;
            }
        }

        public void update(IPeaks peaks, boolean forceReload) {
            evaluatedPeaks = peaks;
            if (parentWidget != null) {
                parentWidget.update(peaks, forceReload);
            }
        }

        public void clear() {
            if (parentWidget != null) {
                parentWidget.clear();
            }
        }

        public IPeaks getPeaks() {
            return evaluatedPeaks;
        }
    }
}

