/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.converter;

import java.io.File;
import org.eclipse.chemclipse.converter.chromatogram.AbstractChromatogramExportConverter;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramExportConverter;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.io.ChromatogramWriterWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.SpecificationValidator;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramExportConverter
extends AbstractChromatogramExportConverter
implements IChromatogramExportConverter {
    private static final Logger logger = Logger.getLogger(ChromatogramExportConverter.class);

    public IProcessingInfo convert(File file, IChromatogram<? extends IPeak> chromatogram, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(file = SpecificationValidator.validateSpecification(file));
        if (!processingInfo.hasErrorMessages() && chromatogram instanceof IChromatogramWSD) {
            IChromatogramWSD chromatogramWSD = (IChromatogramWSD)chromatogram;
            ChromatogramWriterWSD writer = new ChromatogramWriterWSD();
            try {
                writer.writeChromatogram(file, chromatogramWSD, monitor);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage("Export Converter", "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
            processingInfo.setProcessingResult((Object)file);
        }
        return processingInfo;
    }
}

