/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.chemclipse.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.csd.converter.io.AbstractChromatogramCSDReader;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.AbstractChromatogramReader;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1001;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1002;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1003;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1004;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1005;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1006;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1007;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1100;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1300;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1301;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.io.IChromatogramCSDZipReader;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.model.chromatogram.VendorChromatogram;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.model.chromatogram.VendorScan;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io.ChromatogramReaderMSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.ReaderHelper;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReaderCSD
extends AbstractChromatogramCSDReader
implements IChromatogramCSDZipReader {
    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramCSD chromatogramOverview = null;
        ReaderHelper readerHelper = new ReaderHelper();
        String version = readerHelper.getVersion(file);
        IChromatogramCSDZipReader chromatogramReader = this.getChromatogramReader(version);
        if (chromatogramReader != null) {
            try {
                chromatogramOverview = chromatogramReader.readOverview(file, monitor);
            }
            catch (Exception e) {
                chromatogramOverview = this.createChromatogramFIDFromMSD(file, monitor);
            }
        } else {
            chromatogramOverview = this.createChromatogramFIDFromMSD(file, monitor);
        }
        return chromatogramOverview;
    }

    public IChromatogramCSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramCSD chromatogramCSD = null;
        ReaderHelper readerHelper = new ReaderHelper();
        String version = readerHelper.getVersion(file);
        IChromatogramCSDZipReader chromatogramReader = this.getChromatogramReader(version);
        if (chromatogramReader != null) {
            try {
                chromatogramCSD = chromatogramReader.read(file, monitor);
            }
            catch (Exception e) {
                chromatogramCSD = this.createChromatogramFIDFromMSD(file, monitor);
            }
        } else {
            chromatogramCSD = this.createChromatogramFIDFromMSD(file, monitor);
        }
        return chromatogramCSD;
    }

    @Override
    public IChromatogramCSD read(ZipInputStream zipInputStream, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        return this.readChromatogram(zipInputStream, directoryPrefix, monitor);
    }

    @Override
    public IChromatogramCSD read(ZipFile zipFile, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        return this.readChromatogram(zipFile, directoryPrefix, monitor);
    }

    private IChromatogramCSD readChromatogram(Object object, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        IChromatogramCSDZipReader chromatogramReader = null;
        IChromatogramCSD chromatogramCSD = null;
        ReaderHelper readerHelper = new ReaderHelper();
        String version = readerHelper.getVersion(object, directoryPrefix);
        chromatogramReader = this.getChromatogramReader(version);
        if (chromatogramReader != null) {
            if (object instanceof ZipInputStream) {
                chromatogramCSD = chromatogramReader.read((ZipInputStream)object, directoryPrefix, monitor);
            } else if (object instanceof ZipFile) {
                chromatogramCSD = chromatogramReader.read((ZipFile)object, directoryPrefix, monitor);
            }
        }
        return chromatogramCSD;
    }

    private IChromatogramCSDZipReader getChromatogramReader(String version) {
        AbstractChromatogramReader chromatogramReader = null;
        if (version.equals("1.0.0.1")) {
            chromatogramReader = new ChromatogramReader_1001();
        } else if (version.equals("1.0.0.2")) {
            chromatogramReader = new ChromatogramReader_1002();
        } else if (version.equals("1.0.0.3")) {
            chromatogramReader = new ChromatogramReader_1003();
        } else if (version.equals("1.0.0.4")) {
            chromatogramReader = new ChromatogramReader_1004();
        } else if (version.equals("1.0.0.5")) {
            chromatogramReader = new ChromatogramReader_1005();
        } else if (version.equals("1.0.0.6")) {
            chromatogramReader = new ChromatogramReader_1006();
        } else if (version.equals("1.0.0.7")) {
            chromatogramReader = new ChromatogramReader_1007();
        } else if (version.equals("1.1.0.0")) {
            chromatogramReader = new ChromatogramReader_1100();
        } else if (version.equals("1.3.0.0")) {
            chromatogramReader = new ChromatogramReader_1300();
        } else if (version.equals("1.3.0.1")) {
            chromatogramReader = new ChromatogramReader_1301();
        }
        return chromatogramReader;
    }

    private IChromatogramCSD createChromatogramFIDFromMSD(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        ChromatogramReaderMSD chromatogramReaderMSD;
        IChromatogramOverview chromatogramOverview;
        VendorChromatogram chromatogramFID = null;
        if (PreferenceSupplier.isForceLoadAlternateDetector() && (chromatogramOverview = (chromatogramReaderMSD = new ChromatogramReaderMSD()).readOverview(file, monitor)) instanceof IChromatogram) {
            int startRetentionTime;
            IChromatogram chromatogram = (IChromatogram)chromatogramOverview;
            chromatogramFID = new VendorChromatogram();
            for (IScan scan : chromatogram.getScans()) {
                VendorScan scanCSD = new VendorScan(scan.getRetentionTime(), scan.getTotalSignal());
                scanCSD.setRelativeRetentionTime(scan.getRelativeRetentionTime());
                scanCSD.setRetentionIndex(scan.getRetentionIndex());
                scanCSD.setTimeSegmentId(scan.getTimeSegmentId());
                scanCSD.setCycleNumber(scan.getCycleNumber());
                chromatogramFID.addScan((IScan)scanCSD);
            }
            chromatogramFID.setConverterId("org.eclipse.chemclipse.xxd.converter.supplier.chemclipse");
            File fileConverted = new File(file.getAbsolutePath().replace(".ocb", "-fromMSD.ocb"));
            chromatogramFID.setFile(fileConverted);
            int scanDelay = startRetentionTime = chromatogramFID.getStartRetentionTime();
            chromatogramFID.setScanDelay(scanDelay);
            int endRetentionTime = chromatogramFID.getStopRetentionTime();
            int scanInterval = endRetentionTime / chromatogramFID.getNumberOfScans();
            chromatogramFID.setScanInterval(scanInterval);
        }
        return chromatogramFID;
    }
}

