/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.io.AbstractChromatogramWriter;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.io.IChromatogramCSDZipWriter;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakModelCSD;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramWriter_1001
extends AbstractChromatogramWriter
implements IChromatogramCSDZipWriter {
    public void writeChromatogram(File file, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        zipOutputStream.setLevel(PreferenceSupplier.getChromatogramCompressionLevel());
        zipOutputStream.setMethod(8);
        this.writeChromatogram(zipOutputStream, "", chromatogram, monitor);
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    @Override
    public void writeChromatogram(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        this.writeVersion(zipOutputStream, directoryPrefix, monitor);
        this.writeChromatogramFolder(zipOutputStream, directoryPrefix, chromatogram, monitor);
    }

    private void writeVersion(ZipOutputStream zipOutputStream, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "VERSION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        String version = "1.0.0.1";
        dataOutputStream.writeInt(version.length());
        dataOutputStream.writeChars(version);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramFolder(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "FID/CHROMATOGRAM/");
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.closeEntry();
        this.writeChromatogramScans(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramBaseline(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramPeaks(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramArea(zipOutputStream, directoryPrefix, chromatogram, monitor);
    }

    private void writeChromatogramScans(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "FID/CHROMATOGRAM/SCANS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        int scan = 1;
        while (scan <= scans) {
            IScanCSD scanFID = chromatogram.getSupplierScan(scan);
            dataOutputStream.writeInt(scanFID.getRetentionTime());
            dataOutputStream.writeFloat(scanFID.getRetentionIndex());
            dataOutputStream.writeFloat(scanFID.getTotalSignal());
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramBaseline(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "FID/CHROMATOGRAM/BASELINE");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        int scan = 1;
        while (scan <= scans) {
            int retentionTime = chromatogram.getSupplierScan(scan).getRetentionTime();
            float backgroundAbundance = baselineModel.getBackgroundAbundance(retentionTime);
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(backgroundAbundance);
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramPeaks(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "FID/CHROMATOGRAM/PEAKS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List peaks = chromatogram.getPeaks();
        dataOutputStream.writeInt(peaks.size());
        for (IChromatogramPeakCSD peak : peaks) {
            this.writePeak(dataOutputStream, (IPeakCSD)peak);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramArea(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "FID/CHROMATOGRAM/AREA");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List chromatogramIntegrationEntries = chromatogram.getChromatogramIntegrationEntries();
        this.writeString(dataOutputStream, chromatogram.getIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, chromatogramIntegrationEntries);
        List backgroundIntegrationEntries = chromatogram.getBackgroundIntegrationEntries();
        this.writeString(dataOutputStream, chromatogram.getIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, backgroundIntegrationEntries);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writePeak(DataOutputStream dataOutputStream, IPeakCSD peak) throws IOException {
        IPeakModelCSD peakModel = peak.getPeakModel();
        this.writeString(dataOutputStream, peak.getDetectorDescription());
        this.writeString(dataOutputStream, peak.getIntegratorDescription());
        this.writeString(dataOutputStream, peak.getModelDescription());
        this.writeString(dataOutputStream, peak.getPeakType().toString());
        dataOutputStream.writeInt(peak.getSuggestedNumberOfComponents());
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStartRetentionTime()));
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStopRetentionTime()));
        IScan scan = peakModel.getPeakMaximum();
        dataOutputStream.writeInt(scan.getRetentionTime());
        dataOutputStream.writeFloat(scan.getRetentionIndex());
        dataOutputStream.writeFloat(scan.getTotalSignal());
        List retentionTimes = peakModel.getRetentionTimes();
        dataOutputStream.writeInt(retentionTimes.size());
        Iterator iterator = retentionTimes.iterator();
        while (iterator.hasNext()) {
            int retentionTime = (Integer)iterator.next();
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(peakModel.getPeakAbundance(retentionTime));
        }
        List integrationEntries = peak.getIntegrationEntries();
        this.writeIntegrationEntries(dataOutputStream, integrationEntries);
    }

    private void writeIntegrationEntries(DataOutputStream dataOutputStream, List<? extends IIntegrationEntry> integrationEntries) throws IOException {
        dataOutputStream.writeInt(integrationEntries.size());
        for (IIntegrationEntry iIntegrationEntry : integrationEntries) {
            dataOutputStream.writeDouble(iIntegrationEntry.getIntegratedArea());
        }
    }

    private void writeString(DataOutputStream dataOutputStream, String value) throws IOException {
        dataOutputStream.writeInt(value.length());
        dataOutputStream.writeChars(value);
    }
}

