/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.supplier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.filter.IPeakFilter;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.IChromatogramSelectionProcessSupplier;
import org.eclipse.chemclipse.processing.ProcessorFactory;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.filter.CRUDListener;
import org.eclipse.chemclipse.processing.supplier.AbstractProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IProcessTypeSupplier.class})
public class IPeakFilterProcessTypeSupplier
implements IProcessTypeSupplier {
    private ProcessorFactory processorFactory;

    public String getCategory() {
        return "Peak Filter";
    }

    @Reference(unbind="-")
    public void setProcessorFactory(ProcessorFactory factory) {
        this.processorFactory = factory;
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        ArrayList list = new ArrayList();
        Collection filters = this.processorFactory.getProcessors(ProcessorFactory.genericClass(IPeakFilter.class), null);
        for (IPeakFilter filter : filters) {
            list.add(new PeakFilterProcessSupplier(filter, this));
        }
        return list;
    }

    public static String getID(IPeakFilter<?> filter) {
        return "PeakFilter:" + filter.getID();
    }

    public class PeakFilterProcessSupplier<ConfigType>
    extends AbstractProcessSupplier<ConfigType>
    implements IChromatogramSelectionProcessSupplier<ConfigType> {
        private final IPeakFilter<ConfigType> filter;

        PeakFilterProcessSupplier(IPeakFilter<ConfigType> filter, IProcessTypeSupplier parent) {
            super(IPeakFilterProcessTypeSupplier.getID(filter), filter.getName(), filter.getDescription(), filter.getConfigClass(), parent, filter.getDataCategories());
            this.filter = filter;
        }

        @Override
        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, ConfigType processSettings, ProcessExecutionContext context) {
            this.doFilter(chromatogramSelection, processSettings, context);
            return chromatogramSelection;
        }

        private <P extends IPeak, C extends IChromatogram<P>> void doFilter(IChromatogramSelection<P, C> chromatogramSelection, ConfigType processSettings, ProcessExecutionContext context) {
            C chromatogram = chromatogramSelection.getChromatogram();
            CopyOnWriteArrayList peaks = new CopyOnWriteArrayList(chromatogram.getPeaks(chromatogramSelection));
            if (this.filter.acceptsIPeaks(peaks)) {
                this.filter.filterIPeaks(new CRUDListener<P, IPeakModel>((IChromatogram)chromatogram, peaks){
                    private final /* synthetic */ IChromatogram val$chromatogram;
                    private final /* synthetic */ List val$peaks;
                    {
                        this.val$chromatogram = iChromatogram;
                        this.val$peaks = list;
                    }

                    public boolean delete(P item) {
                        this.val$chromatogram.removePeak((IPeak)item);
                        return this.val$peaks.remove(item);
                    }

                    public Collection<P> read() {
                        return Collections.unmodifiableCollection(this.val$peaks);
                    }
                }, processSettings, (MessageConsumer)context, context.getProgressMonitor());
            }
        }
    }
}

