/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.identifier;

import java.util.function.DoubleSupplier;
import org.eclipse.chemclipse.model.identifier.AbstractComparisonResult;
import org.eclipse.chemclipse.model.identifier.MatchConstraints;

public class LazyComparisonResult
extends AbstractComparisonResult {
    private static final long serialVersionUID = 1L;
    private DoubleSupplier matchFactorSupplier;
    private DoubleSupplier reverseMatchFactorSupplier;
    private DoubleSupplier matchFactorDirectSupplier;
    private DoubleSupplier reverseMatchFactorDirectSupplier;
    private MatchConstraints matchConstraints;

    public LazyComparisonResult(DoubleSupplier matchFactor, DoubleSupplier reverseMatchFactor, DoubleSupplier matchFactorDirect, DoubleSupplier reverseMatchFactorDirect, MatchConstraints matchConstraints) {
        super(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        this.matchFactorSupplier = matchFactor;
        this.reverseMatchFactorSupplier = reverseMatchFactor;
        this.matchFactorDirectSupplier = matchFactorDirect;
        this.reverseMatchFactorDirectSupplier = reverseMatchFactorDirect;
        this.matchConstraints = matchConstraints;
    }

    @Override
    public float getMatchFactorNotAdjusted() {
        float matchFactor = super.getMatchFactorNotAdjusted();
        if (Float.isNaN(matchFactor)) {
            matchFactor = (float)this.matchFactorSupplier.getAsDouble();
            this.setMatchFactor(matchFactor);
        }
        return matchFactor;
    }

    @Override
    public float getReverseMatchFactorNotAdjusted() {
        float reverseMatchFactor = super.getReverseMatchFactorNotAdjusted();
        if (Float.isNaN(reverseMatchFactor)) {
            if (this.runReverseMatch()) {
                reverseMatchFactor = (float)this.reverseMatchFactorSupplier.getAsDouble();
                this.setReverseMatchFactor(reverseMatchFactor);
            } else {
                this.setReverseMatchFactor(0.0f);
            }
        }
        return reverseMatchFactor;
    }

    @Override
    public float getMatchFactorDirectNotAdjusted() {
        float matchFactorDirect = super.getMatchFactorDirectNotAdjusted();
        if (Float.isNaN(matchFactorDirect)) {
            if (this.runMatchDirect()) {
                matchFactorDirect = (float)this.matchFactorDirectSupplier.getAsDouble();
                this.setMatchFactorDirect(matchFactorDirect);
            } else {
                this.setMatchFactorDirect(0.0f);
            }
        }
        return matchFactorDirect;
    }

    @Override
    public float getReverseMatchFactorDirectNotAdjusted() {
        float reverseMatchFactorDirect = super.getReverseMatchFactorDirectNotAdjusted();
        if (Float.isNaN(reverseMatchFactorDirect)) {
            if (this.runReverseMatchDirect()) {
                reverseMatchFactorDirect = (float)this.reverseMatchFactorDirectSupplier.getAsDouble();
                this.setReverseMatchFactorDirect(reverseMatchFactorDirect);
            } else {
                this.setReverseMatchFactorDirect(0.0f);
            }
        }
        return reverseMatchFactorDirect;
    }

    private boolean runReverseMatch() {
        return this.getMatchFactorNotAdjusted() >= this.matchConstraints.getMinMatchFactor();
    }

    private boolean runMatchDirect() {
        if (this.runReverseMatch()) {
            return this.getReverseMatchFactorNotAdjusted() >= this.matchConstraints.getMinReverseMatchFactor();
        }
        return false;
    }

    private boolean runReverseMatchDirect() {
        if (this.runMatchDirect()) {
            return this.getMatchFactorDirectNotAdjusted() >= this.matchConstraints.getMinMatchFactorDirect();
        }
        return false;
    }
}

