/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.comparator;

import java.util.Comparator;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.support.comparator.SortOrder;

public class TargetManuallyVerifiedComparator
implements Comparator<IIdentificationTarget> {
    private SortOrder sortOrder;

    public TargetManuallyVerifiedComparator() {
        this.sortOrder = SortOrder.ASC;
    }

    public TargetManuallyVerifiedComparator(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Override
    public int compare(IIdentificationTarget identificationTarget1, IIdentificationTarget identificationTarget2) {
        int returnValue;
        if (identificationTarget1 == null || identificationTarget2 == null) {
            return 0;
        }
        boolean isManuallyVerified1 = identificationTarget1.isManuallyVerified();
        boolean isManuallyVerified2 = identificationTarget2.isManuallyVerified();
        switch (this.sortOrder) {
            case ASC: {
                returnValue = Boolean.compare(isManuallyVerified1, isManuallyVerified2);
                break;
            }
            case DESC: {
                returnValue = Boolean.compare(isManuallyVerified2, isManuallyVerified1);
                break;
            }
            default: {
                returnValue = 0;
            }
        }
        return returnValue;
    }
}

