/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.eclipse.chemclipse.model.comparator.TargetManuallyVerifiedComparator;
import org.eclipse.chemclipse.model.comparator.TargetMatchFactorComparator;
import org.eclipse.chemclipse.model.comparator.TargetReverseMatchFactorComparator;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.support.comparator.SortOrder;

public class TargetExtendedComparator
implements Comparator<IIdentificationTarget>,
Serializable {
    private static final long serialVersionUID = 1364090286565655976L;
    private final Comparator<IIdentificationTarget> firstComparator;
    private final Comparator<IIdentificationTarget> secondComparator;
    private final Comparator<IIdentificationTarget> thirdComparator;

    public TargetExtendedComparator() {
        this(SortOrder.ASC);
    }

    public TargetExtendedComparator(SortOrder sortOrder) {
        this.firstComparator = new TargetManuallyVerifiedComparator(sortOrder);
        this.secondComparator = new TargetMatchFactorComparator(sortOrder);
        this.thirdComparator = new TargetReverseMatchFactorComparator(sortOrder);
    }

    @Override
    public int compare(IIdentificationTarget identificationTarget1, IIdentificationTarget identificationTarget2) {
        int result = this.firstComparator.compare(identificationTarget1, identificationTarget2);
        if (result != 0) {
            return result;
        }
        result = this.secondComparator.compare(identificationTarget1, identificationTarget2);
        if (result != 0) {
            return result;
        }
        result = this.thirdComparator.compare(identificationTarget1, identificationTarget2);
        return result;
    }
}

