/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.eclipse.chemclipse.model.comparator.TargetMatchFactorComparator;
import org.eclipse.chemclipse.model.comparator.TargetReverseMatchFactorComparator;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.support.comparator.SortOrder;

public class TargetCombinedComparator
implements Comparator<IIdentificationTarget>,
Serializable {
    private static final long serialVersionUID = -6174844361574013014L;
    private final Comparator<IIdentificationTarget> firstComparator;
    private final Comparator<IIdentificationTarget> secondComparator;

    public TargetCombinedComparator() {
        this(SortOrder.ASC);
    }

    public TargetCombinedComparator(SortOrder sortOrder) {
        this.firstComparator = new TargetMatchFactorComparator(sortOrder);
        this.secondComparator = new TargetReverseMatchFactorComparator(sortOrder);
    }

    @Override
    public int compare(IIdentificationTarget identificationTarget1, IIdentificationTarget identificationTarget2) {
        int result = this.firstComparator.compare(identificationTarget1, identificationTarget2);
        if (result != 0) {
            return result;
        }
        result = this.secondComparator.compare(identificationTarget1, identificationTarget2);
        return result;
    }
}

