/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.columns;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.model.columns.ISeparationColumn;
import org.eclipse.chemclipse.model.columns.ISeparationColumnIndices;
import org.eclipse.chemclipse.model.columns.SeparationColumn;
import org.eclipse.chemclipse.model.columns.SeparationColumnIndices;

public class SeparationColumnFactory {
    public static final String TYPE_DEFAULT = "DEFAULT";
    public static final String TYPE_POLAR = "POLAR";
    public static final String TYPE_APOLAR = "APOLAR";
    public static final String TYPE_SEMI_POLAR = "SEMI-POLAR";
    public static final String TYPE_DB1 = "DB1";
    public static final String TYPE_DB5 = "DB5";
    public static final String TYPE_DB1701 = "DB1701";
    public static final String TYPE_ZB1 = "ZB-1";
    public static final String TYPE_WAX_PLUS = "WAX+";

    public static List<ISeparationColumn> getSeparationColumns() {
        ArrayList<ISeparationColumn> separationColumns = new ArrayList<ISeparationColumn>();
        separationColumns.add(SeparationColumnFactory.getSeparationColumn(TYPE_DEFAULT));
        separationColumns.add(SeparationColumnFactory.getSeparationColumn(TYPE_POLAR));
        separationColumns.add(SeparationColumnFactory.getSeparationColumn(TYPE_APOLAR));
        separationColumns.add(SeparationColumnFactory.getSeparationColumn(TYPE_SEMI_POLAR));
        separationColumns.add(SeparationColumnFactory.getSeparationColumn(TYPE_DB1));
        separationColumns.add(SeparationColumnFactory.getSeparationColumn(TYPE_DB5));
        separationColumns.add(SeparationColumnFactory.getSeparationColumn(TYPE_DB1701));
        separationColumns.add(SeparationColumnFactory.getSeparationColumn(TYPE_ZB1));
        separationColumns.add(SeparationColumnFactory.getSeparationColumn(TYPE_WAX_PLUS));
        return separationColumns;
    }

    public static ISeparationColumn getSeparationColumn(String name) {
        return new SeparationColumn(name, "", "", "");
    }

    public static ISeparationColumnIndices getSeparationColumnIndices(String name) {
        SeparationColumnIndices separationColumnIndices = new SeparationColumnIndices();
        separationColumnIndices.getSeparationColumn().setName(name);
        return separationColumnIndices;
    }
}

