/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.ui.handlers;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Named;
import org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.ui.internal.handlers.ReportRunnable;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ReportHandler
implements EventHandler {
    private static final Logger logger = Logger.getLogger(ReportHandler.class);
    private static IChromatogramSelection chromatogramSelection;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        String defaultFileName;
        File file;
        IChromatogram chromatogram;
        if (chromatogramSelection != null && (chromatogram = chromatogramSelection.getChromatogram()) != null && (file = this.getFileFromFileDialog(defaultFileName = String.valueOf(chromatogram.getName()) + ".txt")) != null) {
            Display display = Display.getCurrent();
            ReportRunnable runnable = new ReportRunnable(file, chromatogram);
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(display.getActiveShell());
            try {
                monitor.run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)e);
            }
            catch (InterruptedException e) {
                logger.warn((Object)e);
            }
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Done: The report has been successfully created.");
        }
    }

    private File getFileFromFileDialog(String defaultFileName) {
        Shell shell = Display.getCurrent().getActiveShell();
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setText("OpenChrom Report");
        fileDialog.setFileName(defaultFileName);
        fileDialog.setFilterExtensions(new String[]{"*.txt"});
        fileDialog.setFilterNames(new String[]{"OpenChrom Report (*.txt)"});
        String fileName = fileDialog.open();
        if (fileName == null || fileName.equals("")) {
            return null;
        }
        return new File(fileName);
    }

    public void handleEvent(Event event) {
        chromatogramSelection = event.getTopic().equals("chromatogram/msd/update/chromatogramselection") ? (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection") : (event.getTopic().equals("chromatogram/csd/update/chromatogramselection") ? (IChromatogramSelectionCSD)event.getProperty("ChromatogramSelection") : (event.getTopic().equals("chromatogram/wsd/update/chromatogramselection") ? (IChromatogramSelectionWSD)event.getProperty("ChromatogramSelection") : null));
    }
}

