/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.IPeakIntegratorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.IPeakIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.PeakIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IPeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.NoIntegratorAvailableException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class PeakIntegratorProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Peak Integrator";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            IPeakIntegratorSupport support = PeakIntegrator.getPeakIntegratorSupport();
            ArrayList list = new ArrayList();
            for (String processorId : support.getAvailableIntegratorIds()) {
                IPeakIntegratorSupplier supplier = support.getIntegratorSupplier(processorId);
                list.add((IProcessSupplier<?>)new PeakIntegratorProcessorSupplier(supplier, this));
            }
            return list;
        }
        catch (NoIntegratorAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class PeakIntegratorProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IPeakIntegrationSettings> {
        public PeakIntegratorProcessorSupplier(IPeakIntegratorSupplier supplier, IProcessTypeSupplier parent) {
            super(supplier.getId(), supplier.getIntegratorName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.MSD, DataType.CSD});
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IPeakIntegrationSettings processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            if (processSettings instanceof IPeakIntegrationSettings) {
                messageConsumer.addMessages(PeakIntegrator.integrate(chromatogramSelection, processSettings, this.getId(), monitor));
            } else {
                messageConsumer.addMessages(PeakIntegrator.integrate(chromatogramSelection, this.getId(), monitor));
            }
            return chromatogramSelection;
        }
    }
}

