/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.settings.ReportSettings3;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReportWriter3 {
    private static final String DELIMITER = "\t";
    private DecimalFormat decimalFormatRetentionTime = ValueFormat.getDecimalFormatEnglish((String)"0.00");
    private DecimalFormat decimalFormatAreaNormal = ValueFormat.getDecimalFormatEnglish((String)"0.0#E0");
    private DecimalFormat decimalFormatConcentration = ValueFormat.getDecimalFormatEnglish((String)"0.000");
    private DateFormat dateFormat = ValueFormat.getDateFormatEnglish();
    private TargetExtendedComparator targetExtendedComparator = new TargetExtendedComparator(SortOrder.DESC);

    public void generate(File file, boolean append, List<IChromatogram<? extends IPeak>> chromatograms, ReportSettings3 reportSettings, IProgressMonitor monitor) throws IOException {
        FileWriter fileWriter = new FileWriter(file, append);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        for (IChromatogram<? extends IPeak> chromatogram : chromatograms) {
            this.printHeader(printWriter, chromatogram);
            printWriter.println("");
            this.printQuantitationResults(printWriter, chromatogram);
            printWriter.println("");
        }
        printWriter.flush();
        fileWriter.flush();
        printWriter.close();
        fileWriter.close();
    }

    private void printHeader(PrintWriter printWriter, IChromatogram<? extends IPeak> chromatogram) {
        printWriter.println("Filename: " + chromatogram.getName());
        printWriter.println("Sample Name: " + chromatogram.getDataName());
        printWriter.println("Additional Info: " + chromatogram.getDetailedInfo() + " " + chromatogram.getMiscInfo());
        printWriter.println("Acquisition Date: " + this.dateFormat.format(chromatogram.getDate()));
        printWriter.println("Operator: " + chromatogram.getOperator());
        printWriter.println("Miscellaneous: " + chromatogram.getMiscInfo());
    }

    private void printQuantitationResults(PrintWriter printWriter, IChromatogram<? extends IPeak> chromatogram) {
        printWriter.print("#");
        printWriter.print(DELIMITER);
        printWriter.print("Identification");
        printWriter.print(DELIMITER);
        printWriter.print("Substance");
        printWriter.print(DELIMITER);
        printWriter.print("RT");
        printWriter.print(DELIMITER);
        printWriter.print("Area");
        printWriter.print(DELIMITER);
        printWriter.print("Conc.");
        printWriter.print(DELIMITER);
        printWriter.print("Unit");
        printWriter.print(DELIMITER);
        printWriter.print("Description");
        printWriter.println("");
        int i = 1;
        for (IPeak peak : chromatogram.getPeaks()) {
            IPeakModel peakModel = peak.getPeakModel();
            ILibraryInformation libraryInformation = IIdentificationTarget.getBestLibraryInformation((Set)peak.getTargets(), (Comparator)this.targetExtendedComparator);
            String identification = libraryInformation != null ? libraryInformation.getName() : "";
            String retentionTime = this.decimalFormatRetentionTime.format((double)peakModel.getRetentionTimeAtPeakMaximum() / 60000.0);
            for (IQuantitationEntry quantitationEntry : peak.getQuantitationEntries()) {
                printWriter.print("P" + i);
                printWriter.print(DELIMITER);
                printWriter.print(identification);
                printWriter.print(DELIMITER);
                printWriter.print(quantitationEntry.getName());
                printWriter.print(DELIMITER);
                printWriter.print(retentionTime);
                printWriter.print(DELIMITER);
                printWriter.print(this.decimalFormatAreaNormal.format(quantitationEntry.getArea()));
                printWriter.print(DELIMITER);
                printWriter.print(this.decimalFormatConcentration.format(quantitationEntry.getConcentration()));
                printWriter.print(DELIMITER);
                printWriter.print(quantitationEntry.getConcentrationUnit());
                printWriter.print(DELIMITER);
                printWriter.print(quantitationEntry.getDescription());
                printWriter.println("");
            }
            ++i;
        }
    }
}

