/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.INoiseCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.INoiseCalculatorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.NoiseCalculatorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.NoiseCalculatorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.exceptions.NoNoiseCalculatorAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class NoiseCalculator {
    private static final Logger logger = Logger.getLogger(NoiseCalculator.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.xxd.calculator.noiseCalculationSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String CALCULATOR_NAME = "calculatorName";
    private static final String NOISE_CALCULATOR = "noiseCalculator";

    private NoiseCalculator() {
    }

    public static String[][] getAvailableCalculatorIds() {
        INoiseCalculatorSupport noiseCalculatorSupport = NoiseCalculator.getNoiseCalculatorSupport();
        String[][] calculatorArray = null;
        try {
            List<String> calculatorIds = noiseCalculatorSupport.getAvailableCalculatorIds();
            int size = calculatorIds.size();
            calculatorArray = new String[size][2];
            int i = 0;
            while (i < size) {
                String name;
                String calculatorId;
                try {
                    calculatorId = calculatorIds.get(i);
                    name = noiseCalculatorSupport.getCalculatorSupplier(calculatorId).getCalculatorName();
                }
                catch (Exception e) {
                    logger.warn((Object)e);
                    calculatorId = "";
                    name = "n.a.";
                }
                calculatorArray[i][0] = name;
                calculatorArray[i][1] = calculatorId;
                ++i;
            }
        }
        catch (NoNoiseCalculatorAvailableException e1) {
            logger.warn((Object)e1);
        }
        if (calculatorArray == null) {
            calculatorArray = new String[0][0];
        }
        return calculatorArray;
    }

    public static INoiseCalculatorSupport getNoiseCalculatorSupport() {
        IConfigurationElement[] extensions;
        NoiseCalculatorSupport noiseCalculatorSupport = new NoiseCalculatorSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            NoiseCalculatorSupplier supplier = new NoiseCalculatorSupplier();
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setDetectorName(element.getAttribute(CALCULATOR_NAME));
            noiseCalculatorSupport.add(supplier);
            ++n2;
        }
        return noiseCalculatorSupport;
    }

    public static INoiseCalculator getNoiseCalculator(String calculatorId) {
        IConfigurationElement element = NoiseCalculator.getConfigurationElement(calculatorId);
        INoiseCalculator instance = null;
        if (element != null) {
            try {
                instance = (INoiseCalculator)element.createExecutableExtension(NOISE_CALCULATOR);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String detectorId) {
        if ("".equals(detectorId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getAttribute(ID).equals(detectorId)) {
                    return element;
                }
                ++n2;
            }
        }
        return null;
    }
}

