/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.core.chromatogram;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.chromatogram.IChromatogramCalculatorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.chromatogram.IChromatogramCalculatorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.exceptions.NoChromatogramCalculatorSupplierAvailableException;

public class ChromatogramCalculatorSupport
implements IChromatogramCalculatorSupport {
    private List<IChromatogramCalculatorSupplier> suppliers = new ArrayList<IChromatogramCalculatorSupplier>();

    protected void add(IChromatogramCalculatorSupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public List<String> getAvailableCalculatorIds() throws NoChromatogramCalculatorSupplierAvailableException {
        this.areChromatogramCalculatorsStored();
        ArrayList<String> availableFilters = new ArrayList<String>();
        for (IChromatogramCalculatorSupplier supplier : this.suppliers) {
            availableFilters.add(supplier.getId());
        }
        return availableFilters;
    }

    @Override
    public String getCalculatorId(int index) throws NoChromatogramCalculatorSupplierAvailableException {
        this.areChromatogramCalculatorsStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoChromatogramCalculatorSupplierAvailableException("There is no chromatogram calculator available with the following id: " + index + ".");
        }
        IChromatogramCalculatorSupplier supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String[] getCalculatorNames() throws NoChromatogramCalculatorSupplierAvailableException {
        this.areChromatogramCalculatorsStored();
        ArrayList<String> filterNames = new ArrayList<String>();
        for (IChromatogramCalculatorSupplier supplier : this.suppliers) {
            filterNames.add(supplier.getCalculatorName());
        }
        return filterNames.toArray(new String[filterNames.size()]);
    }

    @Override
    public IChromatogramCalculatorSupplier getCalculatorSupplier(String calculatorId) throws NoChromatogramCalculatorSupplierAvailableException {
        IChromatogramCalculatorSupplier filterSupplier = null;
        this.areChromatogramCalculatorsStored();
        if (calculatorId == null || calculatorId.equals("")) {
            throw new NoChromatogramCalculatorSupplierAvailableException("There is no chromatogram calculator supplier available with the following id: " + calculatorId + ".");
        }
        for (IChromatogramCalculatorSupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(calculatorId)) continue;
            filterSupplier = supplier;
            break;
        }
        if (filterSupplier == null) {
            throw new NoChromatogramCalculatorSupplierAvailableException("There is no chromatogram calculator supplier available with the following id: " + calculatorId + ".");
        }
        return filterSupplier;
    }

    private void areChromatogramCalculatorsStored() throws NoChromatogramCalculatorSupplierAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoChromatogramCalculatorSupplierAvailableException();
        }
    }
}

