/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.savitzkygolay.core;

import java.util.ArrayList;
import org.eclipse.chemclipse.chromatogram.filter.result.IChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.calculator.FilterSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.savitzkygolay.processor.SavitzkyGolayProcessor;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.savitzkygolay.settings.ChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.savitzkygolay.settings.MassSpectrumFilterSettings;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.filter.IScanFilter;
import org.eclipse.chemclipse.model.filter.ITotalScanSignalsFilter;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.msd.model.core.IIonProvider;
import org.eclipse.chemclipse.processing.core.DefaultProcessingResult;
import org.eclipse.chemclipse.processing.core.IProcessingResult;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.eclipse.chemclipse.processing.filter.FilterList;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={Filter.class, IScanFilter.class, ITotalScanSignalsFilter.class})
public class SavitzkyGolaySmoothingFilter
implements IScanFilter<MassSpectrumFilterSettings>,
ITotalScanSignalsFilter<MassSpectrumFilterSettings> {
    public String getName() {
        return "Savitzky-Golay Smoothing";
    }

    public MassSpectrumFilterSettings createNewConfiguration() {
        return new MassSpectrumFilterSettings();
    }

    public IProcessingResult<Boolean> filterIScans(FilterList<IScan> filterItems, MassSpectrumFilterSettings configuration, IProgressMonitor monitor) throws IllegalArgumentException {
        int width;
        int order;
        if (configuration == null) {
            configuration = this.createNewConfiguration();
        }
        DefaultProcessingResult result = new DefaultProcessingResult();
        ArrayList<IIonProvider> massSpectra = new ArrayList<IIonProvider>();
        for (IScan scan : filterItems) {
            IIonProvider ionProvider = (IIonProvider)Adapters.adapt((Object)scan, IIonProvider.class);
            if (ionProvider != null) {
                massSpectra.add(ionProvider);
                continue;
            }
            throw new IllegalArgumentException("Input contains invalid scan, use IScanFilter#acceptsIScan(IScan) to check for compatible types");
        }
        int derivative = configuration.getDerivative();
        IProcessingResult<Integer> golayFilter = new FilterSupplier().applySavitzkyGolayFilter(massSpectra, derivative, order = configuration.getOrder(), width = configuration.getWidth(), monitor);
        result.setProcessingResult((Object)((Integer)golayFilter.getProcessingResult() > 0 ? 1 : 0));
        result.addMessages(golayFilter);
        result.addInfoMessage(this.getName(), String.valueOf(filterItems.size()) + " scan(s) were smoothed with derivative=" + derivative + ", order=" + order + ", width=" + width);
        return result;
    }

    public boolean acceptsIScan(IScan item) {
        return Adapters.adapt((Object)item, IIonProvider.class) != null;
    }

    public IProcessingResult<Boolean> filterITotalScanSignalss(FilterList<ITotalScanSignals> filterItems, MassSpectrumFilterSettings configuration, IProgressMonitor monitor) throws IllegalArgumentException {
        if (configuration == null) {
            configuration = this.createNewConfiguration();
        }
        ChromatogramFilterSettings cfs = new ChromatogramFilterSettings();
        cfs.setDerivative(configuration.getDerivative());
        cfs.setOrder(configuration.getOrder());
        cfs.setWidth(configuration.getWidth());
        SavitzkyGolayProcessor processor = new SavitzkyGolayProcessor();
        DefaultProcessingResult result = new DefaultProcessingResult();
        for (ITotalScanSignals signals : filterItems) {
            IChromatogramFilterResult filterResult = SavitzkyGolayProcessor.apply(signals, cfs, monitor);
            if (filterResult.getResultStatus() != ResultStatus.OK) {
                result.addErrorMessage(this.getName(), filterResult.getDescription());
                break;
            }
            result.addInfoMessage(this.getName(), filterResult.getDescription());
            result.setProcessingResult((Object)Boolean.TRUE);
        }
        return result;
    }

    public Class<MassSpectrumFilterSettings> getConfigClass() {
        return null;
    }

    public boolean acceptsITotalScanSignals(ITotalScanSignals item) {
        return true;
    }
}

