/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.report.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.xxd.report.core.ChromatogramReports;
import org.eclipse.chemclipse.chromatogram.xxd.report.core.IChromatogramReportSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.report.core.IChromatogramReportSupport;
import org.eclipse.chemclipse.chromatogram.xxd.report.exceptions.NoReportSupplierAvailableException;
import org.eclipse.chemclipse.chromatogram.xxd.report.settings.DefaultChromatogramReportSettings;
import org.eclipse.chemclipse.chromatogram.xxd.report.settings.IChromatogramReportSettings;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class ChromatogramReportsProcessSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Chromatogram Reports";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            ArrayList list = new ArrayList();
            IChromatogramReportSupport support = ChromatogramReports.getChromatogramReportSupplierSupport();
            for (String processorId : support.getAvailableProcessorIds()) {
                IChromatogramReportSupplier supplier = support.getReportSupplier(processorId);
                list.add((IProcessSupplier<?>)new ChromatogramReportProcessorSupplier(supplier, this));
            }
            return list;
        }
        catch (NoReportSupplierAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class ChromatogramReportProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IChromatogramReportSettings> {
        private IChromatogramReportSupplier supplier;

        public ChromatogramReportProcessorSupplier(IChromatogramReportSupplier supplier, IProcessTypeSupplier parent) {
            super(supplier.getId(), supplier.getReportName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.MSD, DataType.CSD, DataType.WSD});
            this.supplier = supplier;
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IChromatogramReportSettings processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            IChromatogramReportSettings settings = processSettings instanceof IChromatogramReportSettings ? processSettings : new DefaultChromatogramReportSettings();
            File exportFolder = settings.getExportFolder();
            if (exportFolder == null) {
                messageConsumer.addErrorMessage(this.getName(), "No outputfolder specified and no default configured");
                return chromatogramSelection;
            }
            String extension = this.supplier.getFileExtension();
            if (exportFolder.exists() || exportFolder.mkdirs()) {
                IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                File file = new File(exportFolder, settings.getFileNamePattern().replace("{chromatogram_name}", chromatogram.getName()).replace("{extension}", extension));
                IProcessingInfo info = ChromatogramReports.generate(file, settings.isAppend(), (IChromatogram<? extends IPeak>)chromatogram, settings, this.getId(), monitor);
                messageConsumer.addMessages((MessageProvider)info);
                messageConsumer.addInfoMessage(this.getName(), "Report written to " + file.getAbsolutePath());
            } else {
                messageConsumer.addErrorMessage(this.getName(), "The specified outputfolder does not exits and can't be created");
            }
            return chromatogramSelection;
        }
    }
}

