/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.wsd.filter.core.chromatogram;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.exceptions.NoChromatogramFilterSupplierAvailableException;
import org.eclipse.chemclipse.chromatogram.wsd.filter.core.chromatogram.IChromatogramFilterSupplierWSD;
import org.eclipse.chemclipse.chromatogram.wsd.filter.core.chromatogram.IChromatogramFilterSupportWSD;

public class ChromatogramFilterSupportWSD
implements IChromatogramFilterSupportWSD {
    private List<IChromatogramFilterSupplierWSD> suppliers = new ArrayList<IChromatogramFilterSupplierWSD>();

    protected void add(IChromatogramFilterSupplierWSD supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public List<String> getAvailableFilterIds() throws NoChromatogramFilterSupplierAvailableException {
        this.areChromatogramFiltersStored();
        ArrayList<String> availableFilters = new ArrayList<String>();
        for (IChromatogramFilterSupplierWSD supplier : this.suppliers) {
            availableFilters.add(supplier.getId());
        }
        return availableFilters;
    }

    @Override
    public String getFilterId(int index) throws NoChromatogramFilterSupplierAvailableException {
        this.areChromatogramFiltersStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoChromatogramFilterSupplierAvailableException("There is no chromatogram filter available with the following id: " + index + ".");
        }
        IChromatogramFilterSupplierWSD supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String[] getFilterNames() throws NoChromatogramFilterSupplierAvailableException {
        this.areChromatogramFiltersStored();
        ArrayList<String> filterNames = new ArrayList<String>();
        for (IChromatogramFilterSupplierWSD supplier : this.suppliers) {
            filterNames.add(supplier.getFilterName());
        }
        return filterNames.toArray(new String[filterNames.size()]);
    }

    @Override
    public IChromatogramFilterSupplierWSD getFilterSupplier(String filterId) throws NoChromatogramFilterSupplierAvailableException {
        IChromatogramFilterSupplierWSD filterSupplier = null;
        this.areChromatogramFiltersStored();
        if (filterId == null || filterId.equals("")) {
            throw new NoChromatogramFilterSupplierAvailableException("There is no chromatogram filter supplier available with the following id: " + filterId + ".");
        }
        for (IChromatogramFilterSupplierWSD supplier : this.suppliers) {
            if (!supplier.getId().equals(filterId)) continue;
            filterSupplier = supplier;
            break;
        }
        if (filterSupplier == null) {
            throw new NoChromatogramFilterSupplierAvailableException("There is no chromatogram filter supplier available with the following id: " + filterId + ".");
        }
        return filterSupplier;
    }

    private void areChromatogramFiltersStored() throws NoChromatogramFilterSupplierAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoChromatogramFilterSupplierAvailableException();
        }
    }
}

