/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.workbench;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.ui.PlatformUI;

public class PreferencesSupport {
    public static void cleanPreferencesByPrefix(List<String> preservePreferencePrefixes) {
        ArrayList<String> preservePreferenceNodes = new ArrayList<String>();
        PreferencesSupport.cleanPreferences(preservePreferencePrefixes, preservePreferenceNodes);
    }

    public static void cleanPreferencesByNodeId(List<String> preservePreferenceNodes) {
        ArrayList<String> preservePreferencePrefixes = new ArrayList<String>();
        PreferencesSupport.cleanPreferences(preservePreferencePrefixes, preservePreferenceNodes);
    }

    public static void cleanPreferences(List<String> preservePreferencePrefixes, List<String> preservePreferenceNodes) {
        PreferenceManager preferenceManager = PlatformUI.getWorkbench().getPreferenceManager();
        for (IPreferenceNode preferenceNode : preferenceManager.getElements(1)) {
            String preferenceNodeId = preferenceNode.getId();
            if (PreferencesSupport.nodeIdStartsWithPrefix(preferenceNodeId, preservePreferencePrefixes) || preservePreferenceNodes.contains(preferenceNodeId)) continue;
            preferenceManager.remove(preferenceNode);
        }
    }

    private static boolean nodeIdStartsWithPrefix(String preferenceNodeId, List<String> preservePreferencePrefixes) {
        if (preservePreferencePrefixes.size() == 0) {
            return false;
        }
        for (String preservePreferencePrefix : preservePreferencePrefixes) {
            if (!preferenceNodeId.startsWith(preservePreferencePrefix)) continue;
            return true;
        }
        return false;
    }
}

