/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.workbench;

import java.util.Collection;
import javax.inject.Inject;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

@Creatable
public class PartSupport {
    @Inject
    private MApplication mApplication;
    @Inject
    private EModelService eModelService;
    @Inject
    private EPartService ePartService;

    public void removeEditorsFromPartStack() {
        MPartStack partStack = (MPartStack)this.eModelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)this.mApplication);
        Collection parts = this.ePartService.getParts();
        for (MPart part : parts) {
            if (part.getObject() == null) continue;
            part.setToBeRendered(false);
            part.setVisible(false);
            partStack.getChildren().remove(part);
        }
    }

    public boolean saveDirtyParts() {
        return this.ePartService.saveAll(true);
    }

    public void focusPart(String partId) {
        MUIElement element = this.eModelService.find(partId, (MUIElement)this.mApplication);
        if (element instanceof MPart) {
            MPart part = (MPart)element;
            if (!this.ePartService.getParts().contains(part)) {
                this.ePartService.createPart(part.getElementId());
            }
            this.ePartService.showPart(part, EPartService.PartState.ACTIVATE);
        }
    }

    public void closePart(final MPart part) {
        final MPartStack partStack = (MPartStack)this.eModelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)this.mApplication);
        part.setToBeRendered(false);
        part.setVisible(false);
        DisplayUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                partStack.getChildren().remove(part);
            }
        });
    }
}

