/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences.fieldeditors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerFieldEditor2
extends FieldEditor {
    public static final int VALIDATE_ON_VALUE_MODIFICATION = 0;
    public static final int VALIDATE_ON_FOCUS_LOST = 1;
    public static int UNLIMITED = -1;
    private boolean isValid;
    protected int oldValue;
    protected Spinner spinner;
    private String errorMessage;
    private int validateStrategy = 0;

    public SpinnerFieldEditor2(String name, String labelText, int strategy, Composite parent) {
        this.init(name, labelText);
        this.setValidateStrategy(strategy);
        this.isValid = false;
        this.errorMessage = JFaceResources.getString((String)"StringFieldEditor.errorMessage");
        this.createControl(parent);
    }

    public SpinnerFieldEditor2(String name, String labelText, Composite parent) {
        this(name, labelText, 0, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.spinner.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected boolean checkState() {
        boolean result = this.doCheckState();
        if (result) {
            this.clearErrorMessage();
        } else {
            this.showErrorMessage(this.errorMessage);
        }
        return result;
    }

    protected boolean doCheckState() {
        return true;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.spinner = this.getTextControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.spinner.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.spinner != null) {
            int value = this.getPreferenceStore().getInt(this.getPreferenceName());
            this.spinner.setSelection(value);
            this.oldValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this.spinner != null) {
            int value = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
            this.spinner.setSelection(value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.spinner.getText());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public int getIntValue() {
        if (this.spinner != null) {
            return this.spinner.getSelection();
        }
        return this.getPreferenceStore().getInt(this.getPreferenceName());
    }

    protected Spinner getTextControl() {
        return this.spinner;
    }

    public Spinner getTextControl(Composite parent) {
        if (this.spinner == null) {
            this.spinner = new Spinner(parent, 2052);
            this.spinner.setMinimum(Integer.MIN_VALUE);
            this.spinner.setMaximum(Integer.MAX_VALUE);
            this.spinner.setFont(parent.getFont());
            switch (this.validateStrategy) {
                case 0: {
                    this.spinner.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            SpinnerFieldEditor2.this.valueChanged();
                        }
                    });
                    break;
                }
                case 1: {
                    this.spinner.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            SpinnerFieldEditor2.this.clearErrorMessage();
                        }
                    });
                    this.spinner.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            SpinnerFieldEditor2.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent e) {
                            SpinnerFieldEditor2.this.valueChanged();
                            SpinnerFieldEditor2.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
                }
            }
            this.spinner.addDisposeListener(event -> {
                Spinner spinner = this.spinner = null;
            });
        } else {
            this.checkParent((Control)this.spinner, parent);
        }
        return this.spinner;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public void setFocus() {
        if (this.spinner != null) {
            this.spinner.setFocus();
        }
    }

    public void setValue(Integer value) {
        if (this.spinner != null) {
            if (value == null) {
                value = 0;
            }
            this.oldValue = this.spinner.getSelection();
            if (this.oldValue != value) {
                this.spinner.setSelection(value.intValue());
                this.valueChanged();
            }
        }
    }

    public void setValidateStrategy(int value) {
        Assert.isTrue((value == 1 || value == 0 ? 1 : 0) != 0);
        this.validateStrategy = value;
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.errorMessage);
    }

    protected void valueChanged() {
        int newValue;
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid);
        }
        if ((newValue = this.spinner.getSelection()) != this.oldValue) {
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTextControl(parent).setEnabled(enabled);
    }
}

