/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences.fieldeditors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.support.ui.preferences.fieldeditors.ITabFolderPreferencePage;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;

public abstract class AbstractTabFolderPreferencePage
extends PreferencePage
implements ITabFolderPreferencePage,
IPropertyChangeListener {
    private TabFolder tabFolder;
    private List<FieldEditor> fieldEditors = null;

    public TabFolder getTabFolder() {
        return this.tabFolder;
    }

    protected Control createContents(Composite parent) {
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginTop = 10;
        gridLayout.marginLeft = 10;
        gridLayout.marginRight = 10;
        GridData gridData = new GridData(1808);
        this.createTabFolder(parent);
        this.createTabItems(gridLayout, gridData);
        this.createFieldEditors();
        this.initialize();
        this.checkState();
        return this.tabFolder;
    }

    private void createTabFolder(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        this.tabFolder = new TabFolder(composite, 2048);
    }

    protected abstract void createFieldEditors();

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                this.checkState();
            } else {
                this.setValid(newValue);
            }
        }
    }

    protected void addField(FieldEditor fieldEditor) {
        if (this.fieldEditors == null) {
            this.fieldEditors = new ArrayList<FieldEditor>();
        }
        this.fieldEditors.add(fieldEditor);
    }

    protected void initialize() {
        if (this.fieldEditors != null) {
            for (FieldEditor fieldEditor : this.fieldEditors) {
                fieldEditor.setPage((DialogPage)this);
                fieldEditor.setPropertyChangeListener((IPropertyChangeListener)this);
                fieldEditor.setPreferenceStore(this.getPreferenceStore());
                fieldEditor.load();
            }
        }
    }

    protected void performDefaults() {
        if (this.fieldEditors != null) {
            for (FieldEditor fieldEditor : this.fieldEditors) {
                fieldEditor.loadDefault();
            }
        }
        this.checkState();
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.fieldEditors != null) {
            for (FieldEditor fieldEditor : this.fieldEditors) {
                fieldEditor.store();
            }
        }
        return true;
    }

    protected void checkState() {
        boolean valid = true;
        if (this.fieldEditors != null) {
            int size = this.fieldEditors.size();
            int i = 0;
            while (i < size) {
                FieldEditor fieldEditor = this.fieldEditors.get(i);
                boolean bl = valid = valid && fieldEditor.isValid();
                if (!valid) {
                    this.setErrorMessage(fieldEditor.getLabelText());
                    break;
                }
                ++i;
            }
        }
        this.setValid(valid);
        if (valid) {
            this.setErrorMessage(null);
        }
    }
}

