/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.p2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class UpdateSiteSupport {
    public void removeProvisioningRepositories() {
        ProvisioningSession session = ProvisioningUI.getDefaultUI().getSession();
        RepositoryTracker repositoryTracker = ProvisioningUI.getDefaultUI().getRepositoryTracker();
        URI[] locationsEnabled = repositoryTracker.getKnownRepositories(session);
        repositoryTracker.removeRepositories(locationsEnabled, session);
        IMetadataRepositoryManager metadataRepositoryManager = (IMetadataRepositoryManager)session.getProvisioningAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        URI[] locationsDisabled = metadataRepositoryManager.getKnownRepositories(8 | repositoryTracker.getMetadataRepositoryFlags());
        repositoryTracker.removeRepositories(locationsDisabled, session);
    }

    public void addDefaultProvisioningRepositories() {
        HashMap<String, String> updateSites = new HashMap<String, String>();
        updateSites.put("Neon", "http://download.eclipse.org/releases/neon");
        updateSites.put("The Eclipse Project Updates", "http://download.eclipse.org/eclipse/updates/4.6");
        updateSites.put("Eclipse Orbit", "http://download.eclipse.org/tools/orbit/downloads/drops/S20190726194335/repository");
        this.addProvisioningRepositories(updateSites);
    }

    public void addProvisioningRepositories(Map<String, String> updateSites) {
        ProvisioningSession session = ProvisioningUI.getDefaultUI().getSession();
        RepositoryTracker repositoryTracker = ProvisioningUI.getDefaultUI().getRepositoryTracker();
        URI[] locations = repositoryTracker.getKnownRepositories(session);
        for (Map.Entry<String, String> updateSite : updateSites.entrySet()) {
            if (!this.updateSiteNeedsToBeAdded(locations, updateSite.getValue())) continue;
            this.addUpdateSite(updateSite, session, repositoryTracker);
        }
    }

    private boolean updateSiteNeedsToBeAdded(URI[] locations, String updateSite) {
        URI[] uRIArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            URI location = uRIArray[n2];
            if (updateSite.equals(this.getCleanURL(location))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private String getCleanURL(URI uri) {
        String url = uri.toString();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length());
        }
        return url;
    }

    private void addUpdateSite(Map.Entry<String, String> updateSite, ProvisioningSession session, RepositoryTracker repositoryTracker) {
        try {
            URI location = new URI(updateSite.getValue());
            repositoryTracker.addRepository(location, updateSite.getKey(), session);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }
}

